/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.container.global;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.TimeUnit;
import org.sonarsource.sonarlint.core.analysis.api.AnalysisEngineConfiguration;
import org.sonarsource.sonarlint.core.analysis.container.global.GlobalTempFolder;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.shaded.org.apache.commons.io.FileUtils;
import org.sonarsource.sonarlint.shaded.org.springframework.context.annotation.Bean;

public class GlobalTempFolderProvider {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final long CLEAN_MAX_AGE = TimeUnit.DAYS.toMillis(21L);
    private static final String TMP_NAME_PREFIX = ".sonarlinttmp_";
    private GlobalTempFolder tempFolder;

    @Bean(value={"GlobalTempFolder"})
    public GlobalTempFolder provide(AnalysisEngineConfiguration globalConfiguration) {
        if (this.tempFolder == null) {
            this.tempFolder = GlobalTempFolderProvider.cleanAndCreateTempFolder(globalConfiguration.getWorkDir());
        }
        return this.tempFolder;
    }

    private static GlobalTempFolder cleanAndCreateTempFolder(Path workingPath) {
        try {
            GlobalTempFolderProvider.cleanTempFolders(workingPath);
        }
        catch (IOException e) {
            LOG.error(String.format("failed to clean global working directory: %s", workingPath), e);
        }
        Path tempDir = GlobalTempFolderProvider.createTempFolder(workingPath);
        return new GlobalTempFolder(tempDir.toFile(), true);
    }

    private static Path createTempFolder(Path workingPath) {
        try {
            Files.createDirectories(workingPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create working path: " + workingPath, e);
        }
        try {
            return Files.createTempDirectory(workingPath, TMP_NAME_PREFIX, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to create temporary folder in " + workingPath, e);
        }
    }

    private static void cleanTempFolders(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, new CleanFilter());){
                for (Path p : stream) {
                    FileUtils.deleteQuietly(p.toFile());
                }
            }
        }
    }

    private static class CleanFilter
    implements DirectoryStream.Filter<Path> {
        private CleanFilter() {
        }

        @Override
        public boolean accept(Path path) throws IOException {
            BasicFileAttributes attrs;
            if (!Files.isDirectory(path, new LinkOption[0]) || !path.getFileName().toString().startsWith(GlobalTempFolderProvider.TMP_NAME_PREFIX)) {
                return false;
            }
            long threshold = System.currentTimeMillis() - CLEAN_MAX_AGE;
            try {
                attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException ioe) {
                LOG.error(String.format("Couldn't read file attributes for %s : ", path), ioe);
                return false;
            }
            long creationTime = attrs.creationTime().toMillis();
            return creationTime < threshold;
        }
    }
}

