/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.sonarapi;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.TextRange;
import org.sonar.api.batch.sensor.issue.IssueLocation;
import org.sonar.api.batch.sensor.issue.MessageFormatting;
import org.sonar.api.batch.sensor.issue.NewIssueLocation;
import org.sonar.api.batch.sensor.issue.NewMessageFormatting;
import org.sonarsource.sonarlint.core.analysis.sonarapi.noop.NoOpNewMessageFormatting;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

public class DefaultSonarLintIssueLocation
implements NewIssueLocation,
IssueLocation {
    private InputComponent component;
    private TextRange textRange;
    private String message;

    @Override
    public DefaultSonarLintIssueLocation on(InputComponent component) {
        Objects.requireNonNull(component, "Component can't be null");
        this.component = component;
        return this;
    }

    @Override
    public DefaultSonarLintIssueLocation at(TextRange location) {
        this.textRange = location;
        return this;
    }

    @Override
    public DefaultSonarLintIssueLocation message(String message) {
        this.message = StringUtils.abbreviate(StringUtils.trimToEmpty(DefaultSonarLintIssueLocation.sanitizeNulls(message)), 4000);
        return this;
    }

    @Override
    public NewIssueLocation message(String message, List<NewMessageFormatting> newMessageFormattings) {
        return this.message(message);
    }

    @Override
    public NewMessageFormatting newMessageFormatting() {
        return new NoOpNewMessageFormatting();
    }

    private static String sanitizeNulls(String message) {
        return StringUtils.replace(message, "\u0000", "[NULL]");
    }

    @Override
    public InputComponent inputComponent() {
        return this.component;
    }

    @Override
    public TextRange textRange() {
        return this.textRange;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public List<MessageFormatting> messageFormattings() {
        return Collections.emptyList();
    }
}

