/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.connected;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.core.client.api.common.AbstractGlobalConfiguration;

public class ConnectedGlobalConfiguration
extends AbstractGlobalConfiguration {
    public static final String DEFAULT_STORAGE_DIR = "storage";
    private final String connectionId;
    private final Path storageRoot;
    private final Map<String, Path> overriddenPluginsPathsByKey;
    private final boolean isSonarCloud;
    private final boolean isHotspotsEnabled;
    private final boolean isDataflowBugDetectionEnabled;

    private ConnectedGlobalConfiguration(Builder builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.storageRoot = builder.storageRoot != null ? builder.storageRoot : this.getSonarLintUserHome().resolve(DEFAULT_STORAGE_DIR);
        this.overriddenPluginsPathsByKey = new HashMap<String, Path>(builder.overriddenPluginsPathsByKey);
        this.isSonarCloud = builder.isSonarCloud;
        this.isHotspotsEnabled = builder.isHotspotsEnabled;
        this.isDataflowBugDetectionEnabled = builder.isDataflowBugDetectionEnabled;
    }

    public static Builder sonarQubeBuilder() {
        return new Builder(false);
    }

    public static Builder sonarCloudBuilder() {
        return new Builder(true);
    }

    public boolean isSonarCloud() {
        return this.isSonarCloud;
    }

    public boolean isHotspotsEnabled() {
        return this.isHotspotsEnabled;
    }

    public boolean isDataflowBugDetectionEnabled() {
        return this.isDataflowBugDetectionEnabled;
    }

    public Path getStorageRoot() {
        return this.storageRoot;
    }

    public String getConnectionId() {
        return this.connectionId;
    }

    public Map<String, Path> getEmbeddedPluginPathsByKey() {
        return this.overriddenPluginsPathsByKey;
    }

    public static final class Builder
    extends AbstractGlobalConfiguration.AbstractBuilder<Builder> {
        private String connectionId;
        private Path storageRoot;
        private final Map<String, Path> overriddenPluginsPathsByKey = new HashMap<String, Path>();
        private final boolean isSonarCloud;
        private boolean isHotspotsEnabled;
        private boolean isDataflowBugDetectionEnabled;

        private Builder(boolean isSonarCloud) {
            this.isSonarCloud = isSonarCloud;
        }

        public Builder setConnectionId(String connectionId) {
            Builder.validate(connectionId);
            this.connectionId = connectionId;
            return this;
        }

        private static void validate(@Nullable String connectionId) {
            if (connectionId == null || connectionId.isEmpty()) {
                throw new IllegalArgumentException("'" + connectionId + "' is not a valid connection ID");
            }
        }

        public Builder setStorageRoot(Path storageRoot) {
            this.storageRoot = storageRoot;
            return this;
        }

        public Builder useEmbeddedPlugin(String pluginKey, Path pluginPath) {
            this.overriddenPluginsPathsByKey.put(pluginKey, pluginPath);
            return this;
        }

        public Builder enableHotspots() {
            this.isHotspotsEnabled = true;
            return this;
        }

        public Builder enableDataflowBugDetection() {
            this.isDataflowBugDetectionEnabled = true;
            return this;
        }

        public ConnectedGlobalConfiguration build() {
            return new ConnectedGlobalConfiguration(this);
        }
    }
}

