/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.commons;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum Language {
    ABAP("abap", "abap", "ABAP", new String[]{".abap", ".ab4", ".flow", ".asprog"}, "sonar.abap.file.suffixes"),
    APEX("apex", "sonarapex", "Apex", new String[]{".cls", ".trigger"}, "sonar.apex.file.suffixes"),
    C("c", "cpp", "C", new String[]{".c", ".h"}, "sonar.c.file.suffixes"),
    CPP("cpp", "cpp", "C++", new String[]{".cc", ".cpp", ".cxx", ".c++", ".hh", ".hpp", ".hxx", ".h++", ".ipp"}, "sonar.cpp.file.suffixes"),
    CS("cs", "csharp", "C#", new String[]{".cs"}, "sonar.cs.file.suffixes"),
    CSS("css", "javascript", "CSS", new String[]{".css", ".less", ".scss"}, "sonar.css.file.suffixes"),
    OBJC("objc", "cpp", "Objective-C", new String[]{".m"}, "sonar.objc.file.suffixes"),
    COBOL("cobol", "cobol", "COBOL", new String[0], "sonar.cobol.file.suffixes"),
    HTML("web", "web", "HTML", new String[]{".html", ".xhtml", ".cshtml", ".vbhtml", ".aspx", ".ascx", ".rhtml", ".erb", ".shtm", ".shtml"}, "sonar.html.file.suffixes"),
    IPYTHON("ipynb", "python", "IPython Notebooks", new String[]{".ipynb"}, "sonar.ipython.file.suffixes"),
    JAVA("java", "java", "Java", new String[]{".java", ".jav"}, "sonar.java.file.suffixes"),
    JS("js", "javascript", "JavaScript", new String[]{".js", ".jsx", ".vue"}, "sonar.javascript.file.suffixes"),
    KOTLIN("kotlin", "kotlin", "Kotlin", new String[]{".kt", ".kts"}, "sonar.kotlin.file.suffixes"),
    PHP("php", "php", "PHP", new String[]{"php", "php3", "php4", "php5", "phtml", "inc"}, "sonar.php.file.suffixes"),
    PLI("pli", "pli", "PL/I", new String[]{".pli"}, "sonar.pli.file.suffixes"),
    PLSQL("plsql", "plsql", "PL/SQL", new String[]{".sql", ".pks", ".pkb"}, "sonar.plsql.file.suffixes"),
    PYTHON("py", "python", "Python", new String[]{".py"}, "sonar.python.file.suffixes"),
    RPG("rpg", "rpg", "RPG", new String[]{".rpg", ".rpgle"}, "sonar.rpg.suffixes"),
    RUBY("ruby", "ruby", "Ruby", new String[]{".rb"}, "sonar.ruby.file.suffixes"),
    SCALA("scala", "sonarscala", "Scala", new String[]{".scala"}, "sonar.scala.file.suffixes"),
    SECRETS("secrets", "text", "Secrets", new String[0], "sonar.secrets.file.suffixes"),
    SWIFT("swift", "swift", "Swift", new String[]{".swift"}, "sonar.swift.file.suffixes"),
    TSQL("tsql", "tsql", "T-SQL", new String[]{".tsql"}, "sonar.tsql.file.suffixes"),
    TS("ts", "javascript", "TypeScript", new String[]{".ts", ".tsx"}, "sonar.typescript.file.suffixes"),
    JSP("jsp", "web", "JSP", new String[]{".jsp", ".jspf", ".jspx"}, "sonar.jsp.file.suffixes"),
    VBNET("vbnet", "vbnet", "VB.NET", new String[]{".vb"}, "sonar.vbnet.file.suffixes"),
    XML("xml", "xml", "XML", new String[]{".xml", ".xsd", ".xsl"}, "sonar.xml.file.suffixes"),
    YAML("yaml", "javascript", "YAML", new String[]{".yml", "yaml"}, "<no public property provided for this language>"),
    JSON("json", "javascript", "JSON", new String[]{".json"}, "<no public property provided for this language>"),
    GO("go", "go", "Go", new String[]{".go"}, "sonar.go.file.suffixes"),
    CLOUDFORMATION("cloudformation", "iac", "CloudFormation", new String[0], "sonar.cloudformation.file.suffixes"),
    DOCKER("docker", "iac", "Docker", new String[0], "sonar.docker.file.suffixes"),
    KUBERNETES("kubernetes", "iac", "Kubernetes", new String[0], "sonar.kubernetes.file.suffixes"),
    TERRAFORM("terraform", "iac", "Terraform", new String[]{".tf"}, "sonar.terraform.file.suffixes"),
    AZURERESOURCEMANAGER("azureresourcemanager", "iac", "AzureResourceManager", new String[]{".bicep"}, "<no public property provided for this language>");

    private String languageKey;
    private String pluginKey;
    private String[] defaultFileSuffixes;
    private String fileSuffixesPropKey;
    private String label;
    private static final Map<String, Language> mMap;

    private static Map<String, Language> initializeMapping() {
        HashMap<String, Language> mMap = new HashMap<String, Language>();
        for (Language l : Language.values()) {
            mMap.put(l.languageKey, l);
        }
        return mMap;
    }

    private Language(String languageKey, String pluginKey, String label, String[] defaultFileSuffixes, String fileSuffixesPropKey) {
        this.languageKey = languageKey;
        this.pluginKey = pluginKey;
        this.label = label;
        this.defaultFileSuffixes = defaultFileSuffixes;
        this.fileSuffixesPropKey = fileSuffixesPropKey;
    }

    public String getLanguageKey() {
        return this.languageKey;
    }

    public String getPluginKey() {
        return this.pluginKey;
    }

    public String getLabel() {
        return this.label;
    }

    public String[] getDefaultFileSuffixes() {
        return this.defaultFileSuffixes;
    }

    public String getFileSuffixesPropKey() {
        return this.fileSuffixesPropKey;
    }

    public boolean shouldSyncInConnectedMode() {
        return !this.equals((Object)IPYTHON);
    }

    public static Set<Language> getLanguagesByPluginKey(String pluginKey) {
        return Stream.of(Language.values()).filter(l -> l.getPluginKey().equals(pluginKey)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Optional<Language> getLanguageByLanguageKey(String languageKey) {
        ArrayList languages = Stream.of(Language.values()).filter(l -> l.getLanguageKey().equals(languageKey)).collect(Collectors.toCollection(ArrayList::new));
        return languages.isEmpty() ? Optional.empty() : Optional.of((Language)((Object)languages.get(0)));
    }

    public static boolean containsPlugin(String pluginKey) {
        return Stream.of(Language.values()).anyMatch(l -> l.getPluginKey().equals(pluginKey));
    }

    public static Optional<Language> forKey(String languageKey) {
        return Optional.ofNullable(mMap.get(languageKey));
    }

    public String toString() {
        return this.getLabel();
    }

    static {
        mMap = Collections.unmodifiableMap(Language.initializeMapping());
    }

    private static class Constants {
        public static final String JAVASCRIPT_PLUGIN_KEY = "javascript";
        private static final String NO_PUBLIC_PROPERTY_PROVIDED_FOR_THIS_LANGUAGE = "<no public property provided for this language>";

        private Constants() {
        }
    }
}

