/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.issuetracking;

import org.sonarsource.sonarlint.core.commons.HotspotReviewStatus;
import org.sonarsource.sonarlint.core.commons.IssueSeverity;
import org.sonarsource.sonarlint.core.commons.RuleType;
import org.sonarsource.sonarlint.core.commons.TextRangeWithHash;
import org.sonarsource.sonarlint.core.issuetracking.Trackable;

public class AbstractTrackable<G>
implements Trackable<G> {
    private final G clientObject;
    protected String ruleKey;
    protected IssueSeverity severity;
    protected RuleType type;
    protected String message;
    protected Integer line;
    protected String lineHash;
    protected TextRangeWithHash textRange;
    protected Long creationDate;
    protected String serverIssueKey;
    protected boolean resolved;
    protected HotspotReviewStatus reviewStatus;

    protected AbstractTrackable(Trackable<G> trackable) {
        this.clientObject = trackable.getClientObject();
        this.ruleKey = trackable.getRuleKey();
        this.severity = trackable.getSeverity();
        this.type = trackable.getType();
        this.message = trackable.getMessage();
        this.line = trackable.getLine();
        this.lineHash = trackable.getLineHash();
        this.textRange = trackable.getTextRange();
        this.creationDate = trackable.getCreationDate();
        this.serverIssueKey = trackable.getServerIssueKey();
        this.resolved = trackable.isResolved();
        this.reviewStatus = trackable.getReviewStatus();
    }

    @Override
    public G getClientObject() {
        return this.clientObject;
    }

    @Override
    public String getRuleKey() {
        return this.ruleKey;
    }

    @Override
    public IssueSeverity getSeverity() {
        return this.severity;
    }

    @Override
    public RuleType getType() {
        return this.type;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Integer getLine() {
        return this.line;
    }

    @Override
    public String getLineHash() {
        return this.lineHash;
    }

    @Override
    public TextRangeWithHash getTextRange() {
        return this.textRange;
    }

    @Override
    public Long getCreationDate() {
        return this.creationDate;
    }

    @Override
    public String getServerIssueKey() {
        return this.serverIssueKey;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public HotspotReviewStatus getReviewStatus() {
        return this.reviewStatus;
    }
}

