/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.plugin.commons.container;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonarsource.sonarlint.shaded.org.springframework.beans.BeanWrapper;
import org.sonarsource.sonarlint.shaded.org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.sonarsource.sonarlint.shaded.org.springframework.beans.factory.support.RootBeanDefinition;

public class PriorityBeanFactory
extends DefaultListableBeanFactory {
    @Override
    @Nullable
    protected String determineHighestPriorityCandidate(Map<String, Object> candidates, Class<?> requiredType) {
        List<Bean> candidateBeans = candidates.entrySet().stream().filter(e -> e.getValue() != null).map(e -> new Bean((String)e.getKey(), e.getValue())).collect(Collectors.toList());
        List<Bean> beansAfterPriority = PriorityBeanFactory.highestPriority(candidateBeans, b -> this.getPriority(b.getInstance()));
        if (beansAfterPriority.isEmpty()) {
            return null;
        }
        if (beansAfterPriority.size() == 1) {
            return beansAfterPriority.get(0).getName();
        }
        List<Bean> beansAfterHierarchy = PriorityBeanFactory.highestPriority(beansAfterPriority, b -> this.getHierarchyPriority(b.getName()));
        if (beansAfterHierarchy.size() == 1) {
            return beansAfterHierarchy.get(0).getName();
        }
        return null;
    }

    private static List<Bean> highestPriority(List<Bean> candidates, Function<Bean, Integer> priorityFunction) {
        ArrayList<Bean> highestPriorityBeans = new ArrayList<Bean>();
        Integer highestPriority = null;
        for (Bean candidate : candidates) {
            Integer candidatePriority = priorityFunction.apply(candidate);
            if (candidatePriority == null) {
                candidatePriority = Integer.MAX_VALUE;
            }
            if (highestPriority == null) {
                highestPriority = candidatePriority;
                highestPriorityBeans.add(candidate);
                continue;
            }
            if (candidatePriority < highestPriority) {
                highestPriorityBeans.clear();
                highestPriority = candidatePriority;
                highestPriorityBeans.add(candidate);
                continue;
            }
            if (!candidatePriority.equals(highestPriority)) continue;
            highestPriorityBeans.add(candidate);
        }
        return highestPriorityBeans;
    }

    @CheckForNull
    private Integer getHierarchyPriority(String beanName) {
        DefaultListableBeanFactory factory = this;
        int i = 1;
        while (factory != null) {
            if (factory.containsBeanDefinition(beanName)) {
                return i;
            }
            factory = (DefaultListableBeanFactory)factory.getParentBeanFactory();
            ++i;
        }
        return null;
    }

    @Override
    protected BeanWrapper instantiateBean(String beanName, RootBeanDefinition mbd) {
        if (mbd.hasBeanClass() && mbd.getBeanClass().getConstructors().length > 1) {
            throw new IllegalStateException("Constructor annotations missing in: " + mbd.getBeanClass());
        }
        return super.instantiateBean(beanName, mbd);
    }

    private static class Bean {
        private final String name;
        private final Object instance;

        public Bean(String name, Object instance) {
            this.name = name;
            this.instance = instance;
        }

        public String getName() {
            return this.name;
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

