/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.organization;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.UrlUtils;
import org.sonarsource.sonarlint.core.serverapi.organization.DefaultRemoteOrganization;
import org.sonarsource.sonarlint.core.serverapi.organization.ServerOrganization;
import org.sonarsource.sonarlint.core.serverapi.proto.sonarcloud.ws.Organizations;

public class OrganizationApi {
    private final ServerApiHelper helper;

    public OrganizationApi(ServerApiHelper helper) {
        this.helper = helper;
    }

    public List<ServerOrganization> listUserOrganizations(ProgressMonitor progress) {
        return this.fetchUserOrganizations(progress);
    }

    public Optional<ServerOrganization> getOrganization(String organizationKey, ProgressMonitor progress) {
        String url = "api/organizations/search.protobuf?organizations=" + UrlUtils.urlEncode(organizationKey);
        return this.getPaginatedOrganizations(url, progress).stream().findFirst();
    }

    private List<ServerOrganization> fetchUserOrganizations(ProgressMonitor progress) {
        String url = "api/organizations/search.protobuf?member=true";
        return this.getPaginatedOrganizations(url, progress);
    }

    private List<ServerOrganization> getPaginatedOrganizations(String url, ProgressMonitor progress) {
        ArrayList<ServerOrganization> result = new ArrayList<ServerOrganization>();
        this.helper.getPaginated(url, Organizations.SearchWsResponse::parseFrom, r -> r.getPaging().getTotal(), Organizations.SearchWsResponse::getOrganizationsList, org -> result.add(new DefaultRemoteOrganization((Organizations.Organization)org)), false, progress);
        return result;
    }
}

