/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.push;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.commons.push.ServerEvent;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.UrlUtils;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.EventParser;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.IssueChangedEventParser;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.RuleSetChangedEventParser;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.SecurityHotspotChangedEventParser;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.SecurityHotspotClosedEventParser;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.SecurityHotspotRaisedEventParser;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.TaintVulnerabilityClosedEventParser;
import org.sonarsource.sonarlint.core.serverapi.push.parsing.TaintVulnerabilityRaisedEventParser;
import org.sonarsource.sonarlint.core.serverapi.stream.Event;
import org.sonarsource.sonarlint.core.serverapi.stream.EventStream;

public class PushApi {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private static final String API_PATH = "api/push/sonarlint_events";
    private static final Map<String, EventParser<?>> parsersByType = Map.of("RuleSetChanged", new RuleSetChangedEventParser(), "IssueChanged", new IssueChangedEventParser(), "TaintVulnerabilityRaised", new TaintVulnerabilityRaisedEventParser(), "TaintVulnerabilityClosed", new TaintVulnerabilityClosedEventParser(), "SecurityHotspotRaised", new SecurityHotspotRaisedEventParser(), "SecurityHotspotChanged", new SecurityHotspotChangedEventParser(), "SecurityHotspotClosed", new SecurityHotspotClosedEventParser());
    private final ServerApiHelper helper;

    public PushApi(ServerApiHelper helper) {
        this.helper = helper;
    }

    public EventStream subscribe(Set<String> projectKeys, Set<Language> enabledLanguages, Consumer<ServerEvent> serverEventConsumer) {
        return new EventStream(this.helper, rawEvent -> PushApi.handleRawEvent(rawEvent, serverEventConsumer)).connect(PushApi.getWsPath(projectKeys, enabledLanguages));
    }

    private static String getWsPath(Set<String> projectKeys, Set<Language> enabledLanguages) {
        return "api/push/sonarlint_events?projectKeys=" + projectKeys.stream().map(UrlUtils::urlEncode).collect(Collectors.joining(",")) + "&languages=" + enabledLanguages.stream().map(Language::getLanguageKey).map(UrlUtils::urlEncode).collect(Collectors.joining(","));
    }

    private static void handleRawEvent(Event rawEvent, Consumer<ServerEvent> serverEventConsumer) {
        LOG.debug("Server event received: {}", (Object)rawEvent);
        PushApi.parse(rawEvent).ifPresent(serverEventConsumer);
    }

    private static Optional<? extends ServerEvent> parse(Event event) {
        String eventType = event.getType();
        if (!parsersByType.containsKey(eventType)) {
            LOG.error("Unknown '{}' event type ", (Object)eventType);
            return Optional.empty();
        }
        try {
            return parsersByType.get(eventType).parse(event.getData());
        }
        catch (Exception e) {
            LOG.error("Cannot parse '{}' received event", (Object)eventType, (Object)e);
            return Optional.empty();
        }
    }
}

