/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.sonarsource.sonarlint.core.commons.progress.ProgressMonitor;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverconnection.ConnectionStorage;
import org.sonarsource.sonarlint.core.serverconnection.FileUtils;
import org.sonarsource.sonarlint.core.serverconnection.ProjectFileListDownloader;
import org.sonarsource.sonarlint.core.serverconnection.proto.Sonarlint;
import org.sonarsource.sonarlint.core.serverconnection.storage.ProtobufFileUtil;
import org.sonarsource.sonarlint.shaded.org.apache.commons.lang3.StringUtils;

public class ProjectStorageUpdateExecutor {
    private final ProjectFileListDownloader projectFileListDownloader;
    private final ConnectionStorage storage;

    public ProjectStorageUpdateExecutor(ConnectionStorage storage) {
        this(storage, new ProjectFileListDownloader());
    }

    ProjectStorageUpdateExecutor(ConnectionStorage storage, ProjectFileListDownloader projectFileListDownloader) {
        this.storage = storage;
        this.projectFileListDownloader = projectFileListDownloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ServerApi serverApi, String projectKey, ProgressMonitor progress) {
        Path temp;
        try {
            temp = Files.createTempDirectory("sonarlint-global-storage", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create temp directory", e);
        }
        try {
            FileUtils.replaceDir(dir -> this.updateComponents(serverApi, projectKey, (Path)dir, progress), this.storage.project(projectKey).filePath(), temp);
        }
        finally {
            org.sonarsource.sonarlint.shaded.org.apache.commons.io.FileUtils.deleteQuietly(temp.toFile());
        }
    }

    void updateComponents(ServerApi serverApi, String projectKey, Path temp, ProgressMonitor progress) {
        List<String> sqFiles = this.projectFileListDownloader.get(serverApi, projectKey, progress);
        Sonarlint.ProjectComponents.Builder componentsBuilder = Sonarlint.ProjectComponents.newBuilder();
        for (String fileKey : sqFiles) {
            int separatorIdx = StringUtils.lastIndexOf((CharSequence)fileKey, ":");
            String relativePath = fileKey.substring(separatorIdx + 1);
            componentsBuilder.addComponent(relativePath);
        }
        ProtobufFileUtil.writeToFile(componentsBuilder.build(), temp.resolve("component_list.pb"));
    }
}

