/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.sonarsource.sonarlint.core.commons.Version;
import org.sonarsource.sonarlint.core.serverapi.ServerApi;
import org.sonarsource.sonarlint.core.serverapi.exception.UnsupportedServerException;
import org.sonarsource.sonarlint.core.serverapi.system.DefaultValidationResult;
import org.sonarsource.sonarlint.core.serverapi.system.ServerInfo;
import org.sonarsource.sonarlint.core.serverapi.system.SystemApi;
import org.sonarsource.sonarlint.core.serverapi.system.ValidationResult;

public class ServerVersionAndStatusChecker {
    private static final String MIN_SQ_VERSION = "7.9";
    private final SystemApi systemApi;

    public ServerVersionAndStatusChecker(ServerApi serverApi) {
        this.systemApi = serverApi.system();
    }

    public ServerInfo checkVersionAndStatus() {
        try {
            return this.checkVersionAndStatusAsync().get();
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Cannot check server version and status", e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException("Cannot check server version and status", cause);
        }
    }

    public CompletableFuture<ServerInfo> checkVersionAndStatusAsync() {
        return this.systemApi.getStatus().thenApply(serverStatus -> {
            ServerVersionAndStatusChecker.checkServerUpAndSupported(serverStatus);
            return serverStatus;
        });
    }

    public static void checkServerUpAndSupported(ServerInfo serverInfo) {
        if (!serverInfo.isUp()) {
            throw new IllegalStateException(ServerVersionAndStatusChecker.serverNotReady(serverInfo));
        }
        Version serverVersion = Version.create(serverInfo.getVersion());
        if (serverVersion.compareToIgnoreQualifier(Version.create(MIN_SQ_VERSION)) < 0) {
            throw new UnsupportedServerException(ServerVersionAndStatusChecker.unsupportedVersion(serverInfo, MIN_SQ_VERSION));
        }
    }

    private static String unsupportedVersion(ServerInfo serverStatus, String minVersion) {
        return "SonarQube server has version " + serverStatus.getVersion() + ". Version should be greater or equal to " + minVersion;
    }

    private static String serverNotReady(ServerInfo serverStatus) {
        return "Server not ready (" + serverStatus.getStatus() + ")";
    }

    public CompletableFuture<ValidationResult> validateStatusAndVersion() {
        return this.validateStatusAndVersion(MIN_SQ_VERSION);
    }

    public CompletableFuture<ValidationResult> validateStatusAndVersion(String minVersion) {
        return this.systemApi.getStatus().thenApply(serverStatus -> {
            if (!serverStatus.isUp()) {
                return new DefaultValidationResult(false, ServerVersionAndStatusChecker.serverNotReady(serverStatus));
            }
            Version serverVersion = Version.create(serverStatus.getVersion());
            if (serverVersion.compareToIgnoreQualifier(Version.create(minVersion)) < 0) {
                return new DefaultValidationResult(false, ServerVersionAndStatusChecker.unsupportedVersion(serverStatus, minVersion));
            }
            return new DefaultValidationResult(true, "Compatible and ready");
        });
    }
}

