/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection.events.hotspot;

import org.sonarsource.sonarlint.core.commons.HotspotReviewStatus;
import org.sonarsource.sonarlint.core.serverapi.push.SecurityHotspotChangedEvent;
import org.sonarsource.sonarlint.core.serverconnection.ConnectionStorage;
import org.sonarsource.sonarlint.core.serverconnection.events.ServerEventHandler;

public class UpdateStorageOnSecurityHotspotChanged
implements ServerEventHandler<SecurityHotspotChangedEvent> {
    private final ConnectionStorage storage;

    public UpdateStorageOnSecurityHotspotChanged(ConnectionStorage storage) {
        this.storage = storage;
    }

    @Override
    public void handle(SecurityHotspotChangedEvent event) {
        String hotspotKey = event.getHotspotKey();
        String projectKey = event.getProjectKey();
        HotspotReviewStatus status = event.getStatus();
        String assignee = event.getAssignee();
        this.update(hotspotKey, projectKey, assignee, status);
    }

    private void update(String hotspotKey, String projectKey, String assignee, HotspotReviewStatus status) {
        this.storage.project(projectKey).findings().updateHotspot(hotspotKey, hotspot -> {
            if (status != null) {
                hotspot.setStatus(status);
            }
            if (assignee != null) {
                hotspot.setAssignee(assignee);
            }
        });
    }
}

