/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection.storage;

import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.sonarsource.sonarlint.core.commons.HotspotReviewStatus;
import org.sonarsource.sonarlint.core.commons.Language;
import org.sonarsource.sonarlint.core.serverapi.hotspot.ServerHotspot;
import org.sonarsource.sonarlint.core.serverconnection.issues.ServerFinding;
import org.sonarsource.sonarlint.core.serverconnection.issues.ServerIssue;
import org.sonarsource.sonarlint.core.serverconnection.issues.ServerTaintIssue;

public interface ProjectServerIssueStore {
    public void replaceAllIssuesOfBranch(String var1, List<ServerIssue> var2);

    public void replaceAllHotspotsOfBranch(String var1, Collection<ServerHotspot> var2);

    public void replaceAllHotspotsOfFile(String var1, String var2, Collection<ServerHotspot> var3);

    public boolean changeHotspotStatus(String var1, HotspotReviewStatus var2);

    public void replaceAllIssuesOfFile(String var1, String var2, List<ServerIssue> var3);

    public void mergeIssues(String var1, List<ServerIssue> var2, Set<String> var3, Instant var4, Set<Language> var5);

    public void mergeTaintIssues(String var1, List<ServerTaintIssue> var2, Set<String> var3, Instant var4, Set<Language> var5);

    public void mergeHotspots(String var1, List<ServerHotspot> var2, Set<String> var3, Instant var4, Set<Language> var5);

    public Optional<Instant> getLastIssueSyncTimestamp(String var1);

    public Set<Language> getLastIssueEnabledLanguages(String var1);

    public Set<Language> getLastTaintEnabledLanguages(String var1);

    public Set<Language> getLastHotspotEnabledLanguages(String var1);

    public Optional<Instant> getLastTaintSyncTimestamp(String var1);

    public Optional<Instant> getLastHotspotSyncTimestamp(String var1);

    public List<ServerIssue> load(String var1, String var2);

    public void replaceAllTaintOfFile(String var1, String var2, List<ServerTaintIssue> var3);

    public List<ServerTaintIssue> loadTaint(String var1, String var2);

    public Collection<ServerHotspot> loadHotspots(String var1, String var2);

    public List<ServerTaintIssue> loadTaint(String var1);

    public boolean updateIssue(String var1, Consumer<ServerIssue> var2);

    public ServerIssue getIssue(String var1);

    public ServerHotspot getHotspot(String var1);

    public Optional<ServerFinding> updateIssueResolutionStatus(String var1, boolean var2, boolean var3);

    public void updateTaintIssue(String var1, Consumer<ServerTaintIssue> var2);

    public void insert(String var1, ServerTaintIssue var2);

    public void insert(String var1, ServerHotspot var2);

    public void deleteTaintIssue(String var1);

    public void deleteHotspot(String var1);

    public void close();

    public void updateHotspot(String var1, Consumer<ServerHotspot> var2);

    public boolean containsIssue(String var1, boolean var2);
}

