/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.spring;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.net.ProxySelector;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import javax.inject.Named;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.sonarsource.sonarlint.core.BindingClueProvider;
import org.sonarsource.sonarlint.core.BindingSuggestionProviderImpl;
import org.sonarsource.sonarlint.core.ConfigurationServiceImpl;
import org.sonarsource.sonarlint.core.ConnectionServiceImpl;
import org.sonarsource.sonarlint.core.ServerApiProvider;
import org.sonarsource.sonarlint.core.SonarProjectsCache;
import org.sonarsource.sonarlint.core.TokenGeneratorHelper;
import org.sonarsource.sonarlint.core.VersionSoonUnsupportedHelper;
import org.sonarsource.sonarlint.core.analysis.AnalysisServiceImpl;
import org.sonarsource.sonarlint.core.branch.SonarProjectBranchServiceImpl;
import org.sonarsource.sonarlint.core.clientapi.backend.initialize.InitializeParams;
import org.sonarsource.sonarlint.core.commons.SonarLintUserHome;
import org.sonarsource.sonarlint.core.embedded.server.AwaitingUserTokenFutureRepository;
import org.sonarsource.sonarlint.core.embedded.server.EmbeddedServer;
import org.sonarsource.sonarlint.core.embedded.server.GeneratedUserTokenHandler;
import org.sonarsource.sonarlint.core.embedded.server.ShowHotspotRequestHandler;
import org.sonarsource.sonarlint.core.embedded.server.ShowIssueRequestHandler;
import org.sonarsource.sonarlint.core.embedded.server.StatusRequestHandler;
import org.sonarsource.sonarlint.core.hotspot.HotspotServiceImpl;
import org.sonarsource.sonarlint.core.http.AskClientCertificatePredicate;
import org.sonarsource.sonarlint.core.http.ClientProxyCredentialsProvider;
import org.sonarsource.sonarlint.core.http.ClientProxySelector;
import org.sonarsource.sonarlint.core.http.ConnectionAwareHttpClientProvider;
import org.sonarsource.sonarlint.core.http.ConnectionUnawareHttpClientProvider;
import org.sonarsource.sonarlint.core.http.HttpClientProvider;
import org.sonarsource.sonarlint.core.issue.IssueServiceImpl;
import org.sonarsource.sonarlint.core.languages.LanguageSupportRepository;
import org.sonarsource.sonarlint.core.local.only.LocalOnlyIssueStorageService;
import org.sonarsource.sonarlint.core.newcode.NewCodeServiceImpl;
import org.sonarsource.sonarlint.core.plugin.PluginsRepository;
import org.sonarsource.sonarlint.core.plugin.PluginsServiceImpl;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationRepository;
import org.sonarsource.sonarlint.core.repository.connection.ConnectionConfigurationRepository;
import org.sonarsource.sonarlint.core.repository.rules.RulesRepository;
import org.sonarsource.sonarlint.core.repository.vcs.ActiveSonarProjectBranchRepository;
import org.sonarsource.sonarlint.core.rules.RulesExtractionHelper;
import org.sonarsource.sonarlint.core.rules.RulesServiceImpl;
import org.sonarsource.sonarlint.core.server.event.ServerEventsService;
import org.sonarsource.sonarlint.core.smartnotifications.SmartNotifications;
import org.sonarsource.sonarlint.core.spring.EventBusListenersRegistererBeanPostProcessor;
import org.sonarsource.sonarlint.core.storage.StorageService;
import org.sonarsource.sonarlint.core.sync.SynchronizationServiceImpl;
import org.sonarsource.sonarlint.core.telemetry.TelemetryServiceImpl;
import org.sonarsource.sonarlint.core.tracking.IssueTrackingServiceImpl;
import org.sonarsource.sonarlint.core.tracking.LocalOnlyIssueRepository;
import org.sonarsource.sonarlint.core.tracking.SecurityHotspotMatchingServiceImpl;
import org.sonarsource.sonarlint.core.usertoken.UserTokenServiceImpl;
import org.sonarsource.sonarlint.core.websocket.WebSocketService;
import org.sonarsource.sonarlint.shaded.org.springframework.context.annotation.Bean;
import org.sonarsource.sonarlint.shaded.org.springframework.context.annotation.Configuration;
import org.sonarsource.sonarlint.shaded.org.springframework.context.annotation.Import;

@Configuration
@Import(value={EventBusListenersRegistererBeanPostProcessor.class, AskClientCertificatePredicate.class, ClientProxySelector.class, ClientProxyCredentialsProvider.class, ConnectionAwareHttpClientProvider.class, ConnectionUnawareHttpClientProvider.class, ConfigurationServiceImpl.class, ConfigurationRepository.class, RulesServiceImpl.class, ServerApiProvider.class, ConnectionConfigurationRepository.class, RulesRepository.class, RulesExtractionHelper.class, PluginsServiceImpl.class, PluginsRepository.class, LanguageSupportRepository.class, ConnectionServiceImpl.class, TokenGeneratorHelper.class, EmbeddedServer.class, StatusRequestHandler.class, GeneratedUserTokenHandler.class, AwaitingUserTokenFutureRepository.class, ShowHotspotRequestHandler.class, ShowIssueRequestHandler.class, BindingSuggestionProviderImpl.class, BindingClueProvider.class, SonarProjectsCache.class, SonarProjectBranchServiceImpl.class, ActiveSonarProjectBranchRepository.class, SynchronizationServiceImpl.class, HotspotServiceImpl.class, IssueServiceImpl.class, AnalysisServiceImpl.class, SmartNotifications.class, IssueTrackingServiceImpl.class, LocalOnlyIssueRepository.class, WebSocketService.class, ServerEventsService.class, VersionSoonUnsupportedHelper.class, LocalOnlyIssueStorageService.class, StorageService.class, NewCodeServiceImpl.class, SecurityHotspotMatchingServiceImpl.class, UserTokenServiceImpl.class})
public class SonarLintSpringAppConfig {
    private final ExecutorService eventExecutorService = Executors.newSingleThreadExecutor(r -> new Thread(r, "SonarLint Client Events Processor"));

    @Bean
    EventBus provideClientEventBus() {
        return new AsyncEventBus("clientEvents", (Executor)this.eventExecutorService);
    }

    @PreDestroy
    void stopClientEventBus() {
        MoreExecutors.shutdownAndAwaitTermination((ExecutorService)this.eventExecutorService, (long)1L, (TimeUnit)TimeUnit.SECONDS);
    }

    @Bean
    TelemetryServiceImpl provideTelemetryService(InitializeParams params, @Named(value="userHome") Path sonarlintUserHome) {
        return new TelemetryServiceImpl(params.getClientInfo().getTelemetryProductKey(), sonarlintUserHome, params.isFocusOnNewCode());
    }

    @Bean(name={"userHome"})
    Path provideSonarLintUserHome(InitializeParams params) {
        Path sonarlintUserHome = Optional.ofNullable(params.getSonarlintUserHome()).map(x$0 -> Paths.get(x$0, new String[0])).orElse(SonarLintUserHome.get());
        SonarLintSpringAppConfig.createFolderIfNeeded(sonarlintUserHome);
        return sonarlintUserHome;
    }

    @Bean(name={"workDir"})
    Path provideSonarLintWorkDir(InitializeParams params, @Named(value="userHome") Path sonarlintUserHome) {
        Path workDir = Optional.ofNullable(params.getWorkDir()).orElse(sonarlintUserHome.resolve("work"));
        SonarLintSpringAppConfig.createFolderIfNeeded(workDir);
        return workDir;
    }

    @Bean(name={"storageRoot"})
    Path provideSonarLintStorageRoot(InitializeParams params, @Named(value="userHome") Path sonarlintUserHome) {
        Path storageRoot = Optional.ofNullable(params.getStorageRoot()).orElse(sonarlintUserHome.resolve("storage"));
        SonarLintSpringAppConfig.createFolderIfNeeded(storageRoot);
        return storageRoot;
    }

    @Bean
    HttpClientProvider provideHttpClientProvider(InitializeParams params, @Named(value="userHome") Path sonarlintUserHome, AskClientCertificatePredicate askClientCertificatePredicate, ProxySelector proxySelector, CredentialsProvider proxyCredentialsProvider) {
        return new HttpClientProvider(params.getClientInfo().getUserAgent(), sonarlintUserHome, askClientCertificatePredicate, proxySelector, proxyCredentialsProvider);
    }

    private static void createFolderIfNeeded(Path path) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create directory '" + path + "'", e);
        }
    }
}

