/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.parser.cobertura;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.xml.OfflineSaxHandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CoberturaReportHandlerBase
extends OfflineSaxHandlerBase {
    private static final String COBERTURA_REPORT_DTD_FILE = "cobertura-report.dtd";
    private static final Pattern COBERTURA_DTD_ID_PATTERN = Pattern.compile("http://cobertura\\.sourceforge\\.net/xml/coverage-(\\d+)\\.dtd");
    public static final String CLASS_ELEMENT = "class";
    public static final String METHODS_ELEMENT = "methods";
    public static final String LINE_ELEMENT = "line";
    public static final String FILENAME_ATTRIBUTE = "filename";
    public static final String LINE_NUMBER_ATTRIBUTE = "number";
    public static final String HITS_ATTRIBUTE = "hits";
    public static final String BRANCH_ATTRIBUTE = "branch";
    public static final String CONDITION_COVERAGE_ATTRIBUTE = "condition-coverage";
    private static final Logger LOGGER = LogManager.getLogger();

    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        Matcher idPatternMatcher = COBERTURA_DTD_ID_PATTERN.matcher(systemId);
        if (idPatternMatcher.matches()) {
            String versionNumber = idPatternMatcher.group(1);
            if (Integer.parseInt(versionNumber) < 3) {
                LOGGER.warn("Upload with old Cobertura DTD (version " + versionNumber + "). Teamscale supports Cobertura since version 03. Still trying to parse the report.");
            }
            return new InputSource(Resource.of(CoberturaReportHandlerBase.class, (String)COBERTURA_REPORT_DTD_FILE).getAsStream());
        }
        return super.resolveEntity(publicId, systemId);
    }
}

