/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.logging.google;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.logging.google.IGoogleCloudMetadataRestClient;
import com.teamscale.logging.google.MonitoredResourceKubernetesContainer;
import java.io.IOException;

public class GoogleCloudMonitoredResourceLoader {
    private static final String POD_NAME_ENV_VARIABLE = "HOSTNAME";
    private static final String CONTAINER_NAME_ENV_VARIABLE = "CONTAINER_NAME";
    private static final String NAMESPACE_ENV_VARIABLE = "NAMESPACE";
    private static final String NOT_FOUND = "Not Found";

    public static MonitoredResourceKubernetesContainer loadKubernetesContainer() throws IOException, ServiceCallException {
        IGoogleCloudMetadataRestClient metadataClient = (IGoogleCloudMetadataRestClient)Retrofit.builder((String)"http://metadata.google.internal/computeMetadata/v1/").withNoAuthentication().create(IGoogleCloudMetadataRestClient.class);
        MonitoredResourceKubernetesContainer.MonitoredResourceLabelsKubernetesContainer labels = new MonitoredResourceKubernetesContainer.MonitoredResourceLabelsKubernetesContainer(GoogleCloudMonitoredResourceLoader.getProjectId(metadataClient), GoogleCloudMonitoredResourceLoader.getLocation(metadataClient), GoogleCloudMonitoredResourceLoader.getClusterName(metadataClient), GoogleCloudMonitoredResourceLoader.getNamespaceName(), GoogleCloudMonitoredResourceLoader.getPodName(), GoogleCloudMonitoredResourceLoader.getContainerName());
        return new MonitoredResourceKubernetesContainer(labels);
    }

    private static String getContainerName() throws IOException {
        String containerName = System.getenv(CONTAINER_NAME_ENV_VARIABLE);
        if (containerName == null) {
            throw new IOException("Could not find environment variable CONTAINER_NAMEto retrieve the pod name.");
        }
        return containerName;
    }

    private static String getPodName() throws IOException {
        String podName = System.getenv(POD_NAME_ENV_VARIABLE);
        if (podName == null) {
            throw new IOException("Could not find environment variable HOSTNAMEto retrieve the pod name.");
        }
        return podName;
    }

    private static String getNamespaceName() throws IOException {
        String namespaceName = System.getenv(NAMESPACE_ENV_VARIABLE);
        if (namespaceName == null) {
            throw new IOException("Could not find environment variable NAMESPACEto retrieve the namespace name.");
        }
        return namespaceName;
    }

    private static String getClusterName(IGoogleCloudMetadataRestClient metadataClient) throws IOException, ServiceCallException {
        String clusterName = metadataClient.getClusterName();
        if (clusterName.equals(NOT_FOUND)) {
            throw new IOException("Could not retrieve cluster name from metadata server.");
        }
        return clusterName;
    }

    private static String getLocation(IGoogleCloudMetadataRestClient metadataClient) throws IOException, ServiceCallException {
        String zone = metadataClient.getZone();
        if (zone.equals(NOT_FOUND)) {
            throw new IOException("Could not retrieve location from metadata server.");
        }
        return zone.substring(zone.lastIndexOf(47) + 1);
    }

    private static String getProjectId(IGoogleCloudMetadataRestClient metadataClient) throws IOException, ServiceCallException {
        String projectId = metadataClient.getProjectId();
        if (projectId.equals(NOT_FOUND)) {
            throw new IOException("Could not retrieve project id from metadata server.");
        }
        return projectId;
    }
}

