/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.abap.jco;

import com.sap.conn.jco.JCo;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRepository;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class JcoUtils {
    public static final String FUNCTION_GET_TEAMSCALE_EXPORT = "/CQSE/GET_TEAMSCALE_EXPORT";
    private static final String FUNCTION_GET_CONQAT_CODE_EXPORT = "/CQSE/GET_CONQAT_CODE_EXPORT";
    private static final String FUNCTION_GET_CONQAT_TGA_EXPORT = "/CQSE/GET_CONQAT_TGA_EXPORT";
    public static final String FUNCTION_RESTART_SCOV = "/CQSE/RESTART_SCOV";
    public static final String FUNCTION_SCHEDULE_BTC_TS_EXPORT = "/CQSE/SCHEDULE_BTC_TS_EXPORT";
    public static final String FUNCTION_GET_ASYNC_TS_EXP_RESULT = "/CQSE/GET_ASYNC_TS_EXP_RESULT";

    public static JCoDestination getJcoDestination(String destinationName) throws ConQATException {
        try {
            return JCoDestinationManager.getDestination((String)destinationName);
        }
        catch (JCoException e) {
            throw new ConQATException("Unable to retrieve destination " + destinationName, (Throwable)e);
        }
    }

    public static JCoFunction getJcoFunction(JCoDestination destination, String functionName) throws ConQATException {
        JCoFunction function;
        String legacyFunctionName = JcoUtils.getLegacyFunctionName(functionName);
        try {
            JCoRepository repository = destination.getRepository();
            function = legacyFunctionName != null ? JcoUtils.getFunctionOrAlternativeLegacyFunction(repository, functionName, legacyFunctionName) : repository.getFunction(functionName);
        }
        catch (JCoException e) {
            throw new ConQATException("Unable to access SAP system for RFC function execution. This could be caused by incorrect credentials.", (Throwable)e);
        }
        if (function == null) {
            Object legacyFunctionMessage = "";
            if (legacyFunctionName != null) {
                legacyFunctionMessage = ", nor its legacy alternative " + legacyFunctionName;
            }
            throw new ConQATException("Function " + functionName + " not found in SAP system" + (String)legacyFunctionMessage + ".");
        }
        return function;
    }

    private static JCoFunction getFunctionOrAlternativeLegacyFunction(JCoRepository repository, String preferredFunction, String legacyFunction) throws JCoException {
        try {
            JCoFunction function = repository.getFunction(preferredFunction);
            if (function != null) {
                return function;
            }
        }
        catch (JCoException jCoException) {
            // empty catch block
        }
        return repository.getFunction(legacyFunction);
    }

    private static String getLegacyFunctionName(String functionName) {
        return switch (functionName) {
            case FUNCTION_GET_TEAMSCALE_EXPORT -> "Z_CQSE_TEAMSCALE_EXPORT";
            case FUNCTION_GET_CONQAT_CODE_EXPORT -> "Z_CQSE_ABAP_EXPORT_FULL";
            case FUNCTION_GET_CONQAT_TGA_EXPORT -> "Z_CQSE_TGA_EXPORT";
            default -> null;
        };
    }

    public static String formatCertificateInSingleLine(String certificateString) {
        String singleLineCertificateString = certificateString.replaceAll("-+(BEGIN|END) CERTIFICATE-+", "");
        singleLineCertificateString = StringUtils.replaceLineBreaks((String)singleLineCertificateString, (String)"");
        return singleLineCertificateString;
    }

    public static String validateTeamscaleConnectorIsAvailableOnSapSystem(String jcoConnectionName, boolean executeFullSynchronizationAsynchronously) throws ConQATException {
        JCoDestination destination = JcoUtils.getJcoDestination(jcoConnectionName);
        try {
            destination.ping();
        }
        catch (JCoException e) {
            throw new ConQATException("Unable to ping destination " + jcoConnectionName, (Throwable)e);
        }
        try {
            JcoUtils.getJcoFunction(destination, FUNCTION_GET_TEAMSCALE_EXPORT);
        }
        catch (ConQATException e) {
            return "RFC function /CQSE/GET_TEAMSCALE_EXPORT not available in SAP system. Teamscale Connector for SAP AS ABAP must be deployed on SAP system first.";
        }
        if (!executeFullSynchronizationAsynchronously) {
            return null;
        }
        String asynchronusFunctionName = FUNCTION_SCHEDULE_BTC_TS_EXPORT;
        try {
            JcoUtils.getJcoFunction(destination, asynchronusFunctionName);
        }
        catch (ConQATException e) {
            return "RFC function " + asynchronusFunctionName + " not available in SAP system. Teamscale Connector for SAP AS ABAP requires to be updated on the SAP system.";
        }
        return null;
    }

    public static String getJcoVersion() {
        return JCo.getVersion();
    }

    private JcoUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

