/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index;

import com.teamscale.core.migration.ETeamscaleVersion;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.resources.ResourceException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class VersionUtil {
    private static final Logger LOGGER = LogManager.getLogger();

    public static String readTeamscaleVersionDetails() {
        return "Version " + String.valueOf(ETeamscaleVersion.CURRENT_VERSION) + " (" + VersionUtil.getTeamscaleVersion() + ")";
    }

    public static String getTeamscaleVersion() {
        return VersionUtil.readVersionFile().orElse("Developer Version");
    }

    private static Optional<String> readVersionFile() {
        String versionFile = "/version.txt";
        if (!Resource.exists(VersionUtil.class, (String)versionFile)) {
            return Optional.empty();
        }
        try {
            return Optional.of(Resource.of(VersionUtil.class, (String)versionFile).getContent().trim());
        }
        catch (ResourceException e) {
            LOGGER.error("Unable to read Teamscale version details from file.", (Throwable)e);
            return Optional.empty();
        }
    }

    private VersionUtil() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

