/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.instance_comparison.snapshot.contributions.global;

import com.teamscale.core.log.LogIndexBase;
import com.teamscale.core.log.worker.GlobalWorkerLogIndex;
import com.teamscale.core.log.worker.ShortWorkerLog;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.global.GlobalComparisonContributorBase;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.global.MaintenanceLogErrorsComparisonContribution;
import com.teamscale.index.admin.instance_comparison.snapshot.contributions.project.IComparisonContributorContext;
import java.util.ArrayList;
import java.util.List;
import org.conqat.engine.persistence.store.StorageException;

public class MaintenanceLogErrorsComparisonContributor
extends GlobalComparisonContributorBase {
    public static final String MAINTENANCE_WORKER_LOG_CONTRIBUTOR = "Maintenance Worker Log Errors";
    private static final List<LogIndexBase.EIndexLogLevel> LOG_LEVELS = List.of(LogIndexBase.EIndexLogLevel.ERROR, LogIndexBase.EIndexLogLevel.FATAL);

    public MaintenanceLogErrorsComparisonContributor(IComparisonContributorContext.GlobalContext context) {
        super(context);
    }

    @Override
    public MaintenanceLogErrorsComparisonContribution createComparisonInput() throws StorageException {
        GlobalWorkerLogIndex globalWorkerLogIndex = (GlobalWorkerLogIndex)this.getGlobalStorageSystem().openGlobalIndex(GlobalWorkerLogIndex.class);
        ArrayList<ShortWorkerLog> workerLogErrors = new ArrayList<ShortWorkerLog>();
        for (LogIndexBase.EIndexLogLevel logLevel : LOG_LEVELS) {
            workerLogErrors.addAll(globalWorkerLogIndex.getEntries(logLevel, 0L, ((IComparisonContributorContext.GlobalContext)this.context).endTimestamp()));
        }
        return new MaintenanceLogErrorsComparisonContribution(MAINTENANCE_WORKER_LOG_CONTRIBUTOR, workerLogErrors, ((IComparisonContributorContext.GlobalContext)this.context).detailed());
    }
}

