/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.admin.profiler;

import com.google.common.collect.Sets;
import com.teamscale.index.admin.profiler.RunningProfilerInfo;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IGlobalIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

@Index(name="running-profilers", options={EStorageOption.COMPRESSED})
public class RunningProfilersIndex
implements IGlobalIndex {
    static final String INDEX_NAME = "running-profilers";
    private static final int NUMBER_OF_PROFILER_RUNS_TO_KEEP = 50;
    private final ValueIndex<RunningProfilerInfo> delegateIndex;

    public RunningProfilersIndex(IStore store) {
        this.delegateIndex = ValueIndex.forSerializable((IStore)store);
    }

    public List<RunningProfilerInfo> getAllProfilerRuns() throws StorageException {
        return this.delegateIndex.getAllEntries().extractSecondList();
    }

    public @Nullable RunningProfilerInfo getRunningProfilerInfo(UUID profilerId) throws StorageException {
        return (RunningProfilerInfo)this.delegateIndex.getValue(profilerId.toString());
    }

    public void updateProfilerInfo(RunningProfilerInfo profilerInfo) throws StorageException {
        this.delegateIndex.setValue(profilerInfo.id().toString(), (Object)profilerInfo);
    }

    public void removeProfilerInfos(List<UUID> profilerIds) throws StorageException {
        this.delegateIndex.removeValues((Collection)CollectionUtils.map(profilerIds, UUID::toString));
    }

    public ProfilerLogCleanupLevels discardOutdatedProfilerRuns() throws StorageException {
        List<RunningProfilerInfo> allProfilerRuns = this.getAllProfilerRuns();
        allProfilerRuns.sort(Comparator.comparingLong(RunningProfilerInfo::lastHeartbeatTimestamp).reversed());
        HashSet<UUID> purgeCompletelyFor = new HashSet<UUID>();
        if (allProfilerRuns.size() > 50) {
            List<RunningProfilerInfo> outdatedRuns = allProfilerRuns.subList(50, allProfilerRuns.size());
            List<UUID> outdatedRunsIds = outdatedRuns.stream().map(RunningProfilerInfo::id).collect(Collectors.toList());
            this.removeProfilerInfos(outdatedRunsIds);
            purgeCompletelyFor.addAll(outdatedRunsIds);
        }
        Set<UUID> pruneOldestEntriesFor = Sets.difference(new HashSet<RunningProfilerInfo>(allProfilerRuns), purgeCompletelyFor).stream().map(RunningProfilerInfo::id).collect(Collectors.toSet());
        return new ProfilerLogCleanupLevels(pruneOldestEntriesFor, purgeCompletelyFor);
    }

    public record ProfilerLogCleanupLevels(Set<UUID> pruneOldestEntriesFor, Set<UUID> purgeCompletelyFor) {
    }
}

