/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.architecture.incremental;

import com.teamscale.index.architecture.incremental.ArchitectureAnalysisUtils;
import com.teamscale.index.dependencies.TypeDependencies;
import com.teamscale.index.dependencies.TypeDependencyIndex;
import com.teamscale.index.dependencies.TypeIndex;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.ListMap;

public class TypeDependencyCalculator {
    private final TypeDependencyIndex typeDependencyIndex;
    private final TypeIndex typeIndex;

    public TypeDependencyCalculator(TypeDependencyIndex typeDependencyIndex, TypeIndex typeIndex) {
        this.typeDependencyIndex = typeDependencyIndex;
        this.typeIndex = typeIndex;
    }

    public Map<String, ListMap<String, ElementLocation>> createDependencies(List<TypeDependencies> allTypeDependencies) throws StorageException {
        HashMap<String, ListMap<String, ElementLocation>> result = new HashMap<String, ListMap<String, ElementLocation>>();
        for (TypeDependencies typeDependencies : allTypeDependencies) {
            String type = typeDependencies.getType();
            result.computeIfAbsent(type, k -> new ListMap()).addAll(typeDependencies.getDependencyLocations());
            ArchitectureAnalysisUtils.addThirdPartyDependencies(this.typeIndex, result, typeDependencies);
        }
        return result;
    }

    public List<String> getThirdPartyDependencies(List<String> uniformPaths) throws StorageException {
        if (uniformPaths.isEmpty()) {
            return Collections.emptyList();
        }
        List<TypeDependencies> allTypeDependencies = this.typeDependencyIndex.getTypeDependencies(uniformPaths);
        return allTypeDependencies.stream().map(TypeDependencies::getDependencies).flatMap(Collection::stream).toList();
    }
}

