/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.backup.local;

import com.teamscale.index.backup.BackupInfo;
import com.teamscale.index.backup.BackupLocationInfo;
import com.teamscale.index.backup.IBackupTarget;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileExtensionFilter;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;

public class LocalFileBackupTarget
implements IBackupTarget {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PART_FILE_EXTENSION = ".part";
    private static final String ZIP_PART_FILE_EXTENSION = ".zip.part";
    private final File file;

    public LocalFileBackupTarget(String backupPath, boolean writeTarget) throws IOException {
        this.file = writeTarget ? (StringUtils.isEmpty((String)backupPath) ? IBackupTarget.getTemporaryFile(ZIP_PART_FILE_EXTENSION) : LocalFileBackupTarget.getBackupWriteFile(backupPath)) : (StringUtils.isEmpty((String)backupPath) ? IBackupTarget.getTemporaryFile(".zip") : LocalFileBackupTarget.getBackupReadFile(backupPath));
    }

    private static File getBackupReadFile(String backupPath) {
        if (!((String)backupPath).toLowerCase().endsWith(".zip")) {
            backupPath = (String)backupPath + ".zip";
        }
        return new File((String)backupPath);
    }

    private static File getBackupWriteFile(String backupPath) {
        if (((String)backupPath).toLowerCase().endsWith(".zip")) {
            backupPath = (String)backupPath + PART_FILE_EXTENSION;
        } else if (!((String)backupPath).toLowerCase().endsWith(ZIP_PART_FILE_EXTENSION)) {
            backupPath = (String)backupPath + ZIP_PART_FILE_EXTENSION;
        }
        return new File((String)backupPath);
    }

    @Override
    public String validate() {
        if (!FileSystemUtils.isValidPath((String)this.file.getAbsolutePath())) {
            return "Storage location for backup ZIP is not a valid path: " + this.file.getAbsolutePath() + "!";
        }
        if (!FileSystemUtils.isPathWriteable((Path)this.file.toPath())) {
            return "Storage location for backup ZIP is not writable: " + this.file.getAbsolutePath() + "!";
        }
        return null;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.file.exists()) {
            throw new IOException("A backup with the given path already exists.");
        }
        FileSystemUtils.ensureParentDirectoryExists((File)this.file);
        return new BufferedOutputStream(new FileOutputStream(this.file));
    }

    @Override
    public void deleteBackupFile() throws IOException {
        FileSystemUtils.deleteFile((File)this.file);
    }

    @Override
    public SeekableByteChannel getReadChannel() throws IOException {
        return Files.newByteChannel(this.file.toPath(), StandardOpenOption.READ);
    }

    @Override
    public Optional<File> getLocalFile() {
        return Optional.of(this.file);
    }

    private File[] getBackupFiles() throws IOException {
        File backupFolder = this.file.getAbsoluteFile().getParentFile();
        if (backupFolder == null) {
            throw new IOException("Failed to determine the parent folder of " + String.valueOf(this.file) + "!");
        }
        File[] zipsInFolder = backupFolder.listFiles((FileFilter)new FileExtensionFilter(new String[]{"zip"}));
        if (zipsInFolder == null) {
            return new File[0];
        }
        return zipsInFolder;
    }

    @Override
    public List<BackupInfo> getBackupsInSameLocation(BackupLocationInfo backupLocationInfo) throws IOException {
        File[] zipsInFolder = this.getBackupFiles();
        ArrayList<BackupInfo> backupInfos = new ArrayList<BackupInfo>();
        for (File zipFile : zipsInFolder) {
            BackupInfo backupInfo = new BackupInfo(zipFile.getAbsolutePath(), zipFile.lastModified());
            if (!backupLocationInfo.isBackupsOfCurrentTeamscaleInstance(backupInfo)) continue;
            backupInfos.add(backupInfo);
        }
        return backupInfos;
    }

    @Override
    public void deleteBackupsInSameLocation(List<BackupInfo> backupInfos) {
        Set filesToDelete = CollectionUtils.mapToSet(backupInfos, BackupInfo::getBackupIdentifier);
        for (String file : filesToDelete) {
            try {
                FileSystemUtils.deleteFile((File)new File(file));
            }
            catch (IOException e) {
                LOGGER.warn("Unable to delete backup Zip file: " + file, (Throwable)e);
            }
        }
    }

    @Override
    public void completeBackup() throws IOException {
        String oldFilename = this.file.getAbsolutePath();
        String newFilename = StringUtils.stripSuffix((String)oldFilename, (String)PART_FILE_EXTENSION);
        FileSystemUtils.renameFileTo((File)this.file, (File)new File(newFilename));
    }
}

