/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones;

import com.teamscale.core.concurrency.IParallelTaskExecutor;
import com.teamscale.index.architecture.assessment.TypeToComponentMapper;
import com.teamscale.index.architecture.scope.ArchitectureDefinition;
import com.teamscale.index.architecture.scope.ArchitectureDefinitionReader;
import com.teamscale.index.architecture.scope.ComponentNode;
import com.teamscale.index.code_clones.core.Clone;
import com.teamscale.index.code_clones.core.CloneClass;
import com.teamscale.index.code_clones.detection.CloneChunk;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.core.core.ConQATException;
import org.jetbrains.annotations.Contract;

public class CloneComponentHelper {
    private static final Logger LOGGER = LogManager.getLogger();
    private final ArchitectureDefinition architectureDefinition;
    private final IParallelTaskExecutor parallelTaskExecutor;
    private final Map<Clone, String> crossComponentCloneToComponent = Collections.synchronizedMap(new IdentityHashMap());

    public CloneComponentHelper(ArchitectureDefinition architectureDefinition, IParallelTaskExecutor parallelTaskExecutor) {
        this.architectureDefinition = architectureDefinition;
        this.parallelTaskExecutor = parallelTaskExecutor;
    }

    @Contract(value="_, _, _ -> new")
    public static @NonNull CloneComponentHelper fromArchitecturePath(@NonNull TokenElementIndex contentIndex, @NonNull String architecturePath, IParallelTaskExecutor parallelTaskExecutor) throws ConQATException {
        return new CloneComponentHelper(CloneComponentHelper.createArchitectureDefinition(contentIndex, architecturePath), parallelTaskExecutor);
    }

    private static @NonNull ArchitectureDefinition createArchitectureDefinition(@NonNull TokenElementIndex contentIndex, @NonNull String architecturePath) throws ConQATException {
        TokenElementInfo architectureFile = contentIndex.getTokenElement(architecturePath);
        if (architectureFile == null) {
            throw new ConQATException("Architecture definition not found: " + architecturePath);
        }
        try {
            return ArchitectureDefinitionReader.read(architecturePath, architectureFile.getText());
        }
        catch (ConQATException e) {
            throw new ConQATException("Could not parse architecture definition: " + architecturePath, (Throwable)e);
        }
    }

    public Predicate<CloneClass> getCrossComponentPredicate(@NonNull Collection<String> uniformPaths) {
        return new CrossComponentPredicate(this.createComponentMappingForPaths(uniformPaths));
    }

    public Optional<String> getCachedCrossComponentNames(@NonNull Clone clone) {
        return Optional.ofNullable(this.crossComponentCloneToComponent.get(clone));
    }

    public TypeToComponentMapper.MappingResult createComponentMappingForPaths(@NonNull Collection<String> uniformPaths) {
        TypeToComponentMapper typeToComponentMapper = new TypeToComponentMapper(this.architectureDefinition, this.parallelTaskExecutor);
        return typeToComponentMapper.map(uniformPaths);
    }

    public TypeToComponentMapper.MappingResult getComponentMappingForChunks(@NonNull Collection<CloneChunk> chunks) {
        return this.createComponentMappingForPaths(CloneComponentHelper.getChunkOrigins(chunks));
    }

    private static @NonNull Set<String> getChunkOrigins(@NonNull Collection<CloneChunk> chunks) {
        return chunks.stream().map(CloneChunk::getOriginId).collect(Collectors.toSet());
    }

    public static void checkIntraComponentCloneClassConsistency(@NonNull Collection<CloneClass> cloneClasses, @NonNull Logger logger) {
        List<CloneClass> list = cloneClasses.stream().filter(Predicate.not(CloneClass::isValidIntraComponentClass)).toList();
        if (!list.isEmpty()) {
            logger.error("Encountered clones with inconsistent components assigned:\n{}", (Object)list.stream().map(CloneClass::toString).collect(Collectors.joining("\n")));
        }
    }

    private class CrossComponentPredicate
    implements Predicate<CloneClass> {
        private final TypeToComponentMapper.MappingResult componentMapping;

        public CrossComponentPredicate(TypeToComponentMapper.MappingResult componentMapping) {
            this.componentMapping = componentMapping;
        }

        @Override
        public boolean test(@NonNull CloneClass cloneClass) {
            HashSet affectedComponents = new HashSet();
            for (Clone clone : cloneClass.getClones()) {
                Set<ComponentNode> components = this.componentMapping.getMappedComponentsForType(clone.getUniformPath());
                if (components.isEmpty()) {
                    if (!CloneComponentHelper.this.architectureDefinition.isIncludedInScope(clone.getUniformPath())) continue;
                    LOGGER.error("File with clone not mapped to a component. Cross- and intra-component clones may be wrong: {}", (Object)clone.getUniformPath());
                    continue;
                }
                components.stream().map(ComponentNode::getName).forEach(affectedComponents::add);
                CloneComponentHelper.this.crossComponentCloneToComponent.put(clone, components.stream().map(ComponentNode::getName).sorted().collect(Collectors.joining(", ")));
            }
            return affectedComponents.size() > 1;
        }
    }
}

