/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones;

import com.teamscale.index.code_clones.CloneInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Index(name="clone-list", options={EStorageOption.BRANCHED, EStorageOption.COMPRESSED})
public class CloneListIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "clone-list";
    private final ValueIndex<ArrayList<CloneInfo>> delegate;

    public CloneListIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public List<@Nullable ArrayList<CloneInfo>> getCloneLists(List<String> uniformPaths) throws StorageException {
        return this.delegate.getValues(uniformPaths);
    }

    public @Nullable ArrayList<CloneInfo> getCloneList(String uniformPath) throws StorageException {
        return (ArrayList)this.delegate.getValue(uniformPath);
    }

    public void setCloneLists(PairList<String, ArrayList<CloneInfo>> uniformPathsAndCloneLists) throws StorageException {
        this.delegate.setValues(uniformPathsAndCloneLists);
    }

    public void removeEntries(Collection<String> uniformPaths) throws StorageException {
        this.delegate.removeValues(uniformPaths);
    }

    public PairList<String, ArrayList<CloneInfo>> getAllCloneLists() throws StorageException {
        return this.delegate.getAllEntries();
    }
}

