/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.core;

import com.teamscale.index.code_clones.core.TokenUnit;
import com.teamscale.index.code_clones.core.Unit;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;

public class StatementUnit
extends Unit {
    private TokenUnit[] tokens;

    public StatementUnit(List<TokenUnit> tokenList, String elementUniformPath, boolean storeTokens, int indexInElement) {
        super(tokenList.get(0).getFilteredStartOffset(), ((TokenUnit)CollectionUtils.getLast(tokenList)).getFilteredEndOffset(), elementUniformPath, StatementUnit.createContent(tokenList), StatementUnit.createUnnormalizedContent(tokenList), indexInElement);
        if (storeTokens) {
            this.tokens = tokenList.toArray(new TokenUnit[0]);
        }
    }

    private static String createUnnormalizedContent(List<TokenUnit> tokens) {
        StringBuilder builder = new StringBuilder();
        for (TokenUnit token : tokens) {
            if (!builder.isEmpty()) {
                builder.append(" ");
            }
            builder.append(token.getUnnormalizedContent());
        }
        return builder.toString();
    }

    private static String createContent(List<TokenUnit> tokens) {
        StringBuilder builder = new StringBuilder();
        for (TokenUnit token : tokens) {
            builder.append(token.getContent());
        }
        return builder.toString();
    }

    @Override
    public String toString() {
        return this.getContent() + " [" + this.getElementUniformPath() + "(f-offset: " + this.getFilteredStartOffset() + ")][index:" + this.getIndexInElement() + "]";
    }

    public TokenUnit[] getTokens() {
        this.assertTokensStored();
        return this.tokens;
    }

    private void assertTokensStored() {
        if (this.tokens == null) {
            throw new IllegalStateException("In order to access the underlying tokens, StatementUnit must store its tokens. (Set storeTokens flag in constructor)");
        }
    }

    public TokenUnit findTokenUnitByCharacterOffset(int offset) {
        for (TokenUnit unit : this.tokens) {
            int contentLength = unit.getContent().length();
            if (offset <= contentLength) {
                return unit;
            }
            offset -= contentLength;
        }
        return null;
    }

    public int getOffsetFromLastTokenUnit() {
        return this.tokens[this.tokens.length - 1].getFilteredStartOffset();
    }
}

