/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.detection;

import java.util.Comparator;
import java.util.Objects;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class CloneChunk {
    private final String originId;
    private final long chunkHash;
    private final int firstUnitIndex;
    private final int firstRawLineNumber;
    private final int lastRawLineNumber;
    private final int rawStartOffset;
    private final int rawEndOffset;
    private final int elementUnits;
    public static final Comparator<CloneChunk> CHUNK_COMPARATOR = Comparator.comparing(CloneChunk::getOriginId).thenComparing(CloneChunk::getFirstUnitIndex);

    public CloneChunk(String originId, long chunkHash, int firstUnitIndex, int firstRawLineNumber, int lastRawLineNumber, int rawStartOffset, int rawEndOffset, int unitCount) {
        this.originId = originId;
        this.chunkHash = chunkHash;
        this.firstUnitIndex = firstUnitIndex;
        this.firstRawLineNumber = firstRawLineNumber;
        this.lastRawLineNumber = lastRawLineNumber;
        this.rawStartOffset = rawStartOffset;
        this.rawEndOffset = rawEndOffset;
        this.elementUnits = unitCount;
    }

    public String getOriginId() {
        return this.originId;
    }

    public long getChunkHash() {
        return this.chunkHash;
    }

    public int getFirstUnitIndex() {
        return this.firstUnitIndex;
    }

    public int getFirstRawLineNumber() {
        return this.firstRawLineNumber;
    }

    public int getLastRawLineNumber() {
        return this.lastRawLineNumber;
    }

    public int getRawStartOffset() {
        return this.rawStartOffset;
    }

    public int getRawEndOffset() {
        return this.rawEndOffset;
    }

    public int getElementUnits() {
        return this.elementUnits;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CloneChunk)) {
            return false;
        }
        CloneChunk other = (CloneChunk)obj;
        return other.originId.equals(this.originId) && other.chunkHash == this.chunkHash && other.firstUnitIndex == this.firstUnitIndex && other.firstRawLineNumber == this.firstRawLineNumber && other.lastRawLineNumber == this.lastRawLineNumber && other.rawStartOffset == this.rawStartOffset && other.rawEndOffset == this.rawEndOffset;
    }

    public int hashCode() {
        return Objects.hash(this.originId, this.chunkHash, this.firstUnitIndex);
    }

    public String toString() {
        return "CloneChunk{origin='" + this.originId + "', hash=" + this.chunkHash + ", firstUnit=" + this.firstUnitIndex + ", lines=" + this.firstRawLineNumber + "-" + this.lastRawLineNumber + ", offsets=" + this.rawStartOffset + "-" + this.rawEndOffset + ", elementUnits=" + this.elementUnits + "}";
    }
}

