/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.code_clones.normalization;

import com.teamscale.index.code_clones.core.TokenUnit;
import com.teamscale.index.code_clones.normalization.GenericNormalizer;
import com.teamscale.index.code_clones.normalization.ITokenReporter;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.IdManager;

class CLikeNormalizer
extends GenericNormalizer {
    private static final Set<ETokenType> SKIPPED_MODIFIERS = EnumSet.of(ETokenType.PUBLIC, new ETokenType[]{ETokenType.PROTECTED, ETokenType.INTERNAL, ETokenType.PRIVATE, ETokenType.FINAL, ETokenType.OVERRIDE});
    private static final Set<ETokenType> SKIPPED_TOKENS = EnumSet.noneOf(ETokenType.class);

    CLikeNormalizer() {
    }

    @Override
    protected boolean isSkippedTokenType(ETokenType tokenType) {
        return super.isSkippedTokenType(tokenType) || SKIPPED_TOKENS.contains(tokenType);
    }

    @Override
    protected String normalizeContent(ETokenType tokenType, String content, IdManager<String> idManager) {
        if (TokenUnit.TYPE_KEYWORDS.contains(tokenType)) {
            return CLikeNormalizer.normalizeString(content, idManager);
        }
        return super.normalizeContent(tokenType, content, idManager);
    }

    @Override
    protected boolean supportConservativeNormalization(ETokenType tokenType) {
        return super.supportConservativeNormalization(tokenType) || TokenUnit.TYPE_KEYWORDS.contains(tokenType);
    }

    @Override
    protected int getNumTokensToSkip(List<IToken> tokens, int currentIndex, ITokenReporter tokenReporter) {
        ETokenType lookahead;
        ETokenType tokenType = tokens.get(currentIndex).getType();
        if (tokenType == ETokenType.THIS && currentIndex + 1 < tokens.size() && ((lookahead = tokens.get(currentIndex + 1).getType()) == ETokenType.DOT || lookahead == ETokenType.POINTERTO)) {
            return 2;
        }
        if (tokenType == ETokenType.IDENTIFIER && currentIndex + 1 < tokens.size() && ((lookahead = tokens.get(currentIndex + 1).getType()) == ETokenType.DOT || lookahead == ETokenType.SCOPE)) {
            tokenReporter.skippedTokensForConservative(2);
            return 2;
        }
        return 0;
    }

    static {
        SKIPPED_TOKENS.addAll(SKIPPED_MODIFIERS);
        SKIPPED_TOKENS.add(ETokenType.PREPROCESSOR_DIRECTIVE);
    }
}

