/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis;

import com.teamscale.index.comment_analysis.Comment;
import com.teamscale.index.comment_analysis.CommentCompletenessAnalyzerBase;
import com.teamscale.index.comment_analysis.InterfaceCommentCoherenceAnalysisBase;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import java.util.EnumSet;
import java.util.regex.Pattern;
import org.conqat.lib.commons.regex.Patterns;
import org.conqat.lib.commons.string.StringUtils;

public class UnrelatedInterfaceCommentAnalysis
extends InterfaceCommentCoherenceAnalysisBase {
    public static final String FINDING_GROUP_NAME = "Unrelated Member Comment";

    public UnrelatedInterfaceCommentAnalysis() {
        super(FINDING_GROUP_NAME);
    }

    @Override
    protected void analyzeCoherence(Comment comment) {
        String commentText = comment.getText();
        if (UnrelatedInterfaceCommentAnalysis.isEmpty(commentText) || UnrelatedInterfaceCommentAnalysis.containsInheritDoc(commentText) || !UnrelatedInterfaceCommentAnalysis.shouldAnalyze(comment)) {
            return;
        }
        Comment commentHeadline = UnrelatedInterfaceCommentAnalysis.getCommentHeadline(comment, false);
        if (UnrelatedInterfaceCommentAnalysis.hasCommentUnnecessaryReturn(comment) || UnrelatedInterfaceCommentAnalysis.getCoherenceCoefficient(commentHeadline) == 0.0) {
            this.createFindingForComment(comment, FINDING_GROUP_NAME);
        }
    }

    private static boolean isEmpty(String commentText) {
        return StringUtils.replaceAll((String)commentText, (Pattern)Patterns.WHITESPACE, (String)"").isEmpty();
    }

    private static boolean containsInheritDoc(String commentText) {
        return CommentCompletenessAnalyzerBase.isInheritdocFoundInCSComment(commentText) || CommentCompletenessAnalyzerBase.isInheritdocFoundInJavaComment(commentText);
    }

    private static boolean shouldAnalyze(Comment comment) {
        return comment.getLanguage() != ELanguage.JAVA || EnumSet.of(ETokenType.JAVADOC_TAG, ETokenType.JAVADOC_INLINE_TAG, ETokenType.DOCUMENTATION_COMMENT).contains(comment.getToken().getType());
    }
}

