/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.comment_analysis.classification;

import com.teamscale.index.comment_analysis.classification.CommentLineCodeChecker;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.ScannerUtils;
import java.util.EnumSet;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

public class CodeCharacteristicsChecker {
    public static final double MINIMUM_CODE_RATIO = 0.43;
    public static final Set<ETokenType> IDENTIFER_TYPES = EnumSet.of(ETokenType.IDENTIFIER, ETokenType.NEW);
    public static final Set<ETokenType> COMMON_NL_TOKENS = EnumSet.of(ETokenType.DOT, new ETokenType[]{ETokenType.COMMA, ETokenType.GET, ETokenType.SET, ETokenType.ELLIPSIS, ETokenType.NOT, ETokenType.AND, ETokenType.THIS, ETokenType.IN, ETokenType.IS, ETokenType.FOR, ETokenType.COLON, ETokenType.ADD, ETokenType.CASE, ETokenType.OBJECT, ETokenType.VALUE, ETokenType.PERMITS, ETokenType.DEFAULT, ETokenType.IF, ETokenType.FILE, ETokenType.AS});
    public static final Set<ETokenType.ETokenClass> IGNORED_TOKEN_CLASSES = EnumSet.of(ETokenType.ETokenClass.WHITESPACE, ETokenType.ETokenClass.SPECIAL, ETokenType.ETokenClass.SYNTHETIC);
    public static final Set<String> KEYWORDS_NEEDING_SYNTAX_CHECK = CollectionUtils.asHashSet((Object[])new String[]{"if", "else", "while", "switch", "do", "try", "catch", "finally", "super", "class"});

    public static ECodeLineResult containsCodeCharacteristic(String commentline, ELanguage language) {
        if (language == ELanguage.CPP || language == ELanguage.CPP_MS_CLI) {
            commentline = commentline.replace("'", "");
        }
        return new CommentLineCodeChecker(ScannerUtils.getTokens((String)commentline, (ELanguage)language, (String)"##commented out code##")).containsCodeCharacteristics();
    }

    public static enum ECodeLineResult {
        CODE,
        NO_CODE,
        DONT_KNOW;

    }
}

