/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration;

import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.MetricSchemaProxy;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.ProjectCreationProxy;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.index.model.CodeScope;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.MetricDescriptor;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.configuration.model.option.ConfigOptionDescriptorBase;
import com.teamscale.core.analysis.trigger.configuration.ETriggerConcurrency;
import com.teamscale.core.metrics.schema.EMetricProperty;
import com.teamscale.core.metrics.schema.MetricDirectorySchemaEntry;
import com.teamscale.core.metrics.values.EMetricValueType;
import com.teamscale.index.comment_analysis.CommentAnalysis;
import com.teamscale.index.comment_analysis.CommentClassificationAnalysisBase;
import com.teamscale.index.comment_analysis.CommentCompletenessAnalyzerBase;
import com.teamscale.index.configuration.CodeScopeUtils;
import com.teamscale.index.configuration.EntitySelectionExpressionValidator;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.core.registry.CheckDescriptionLoader;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;

public class CommentAnalysisConfiguration
extends AnalysisConfigurationBase {
    private static final String REQUIRED_INTERFACE_COMMENTS_SELECTOR = "Required interface comments";
    private static final String INTERFACE_COMMENT_COMPLETENESS_OPTION = "Interface comment completeness";
    private static final String INTERFACE_COMMENTS_MUST_BE_DOC_COMMENTS = "Interface comments must be doc comments";
    private static final String CPP_HEADER_COMMENTING_STYLE_SELECTOR_EXPRESSION = "type | (public & (attribute | (method & declaration)))";
    public static final String JAVASCRIPT_DEFAULT_SELECTOR_EXPRESSION = "(public | default | export) & (type | method | attribute) & !subtype(constructor) & !override";
    private static final String CS_DEFAULT_SELECTOR_EXPRESSION = "public & (type | method | property) & !(simpleGetter | simpleSetter | annotated(Override) | override)";
    public static final String ABAP_DEFAULT_SELECTOR_EXPRESSION = "public & (attribute | method | type) & !(method & (name(constructor) | name(class_constructor) | redefinition))";
    private static final String PYTHON_DEFAULT_SELECTOR_EXPRESSION = "type | method";
    private final CodeScopeAware<FindingDescriptor> commentedCodeFinding = CodeScopeAware.defaultCodeScopeWithValue((Object)new FindingDescriptor("Commented-out code", EAnalysisTool.TEAMSCALE, CommentClassificationAnalysisBase.CLASSIFIERS.keySet(), EFindingEnablement.YELLOW, (String)CheckDescriptionLoader.getCheckDescription(((Object)((Object)this)).getClass(), (String)"cqse-commented-code.md").orElseThrow()));
    private final CodeScopeAware<MetricDescriptor> commentRatioMetric = CodeScopeAware.defaultCodeScopeWithValue((Object)new MetricDescriptor("Comment ratio", "The comment ratio on the character level.", false));
    private final CodeScopeAware<MetricDescriptor> commentCompletenessAssessment = CodeScopeAware.defaultCodeScopeWithValue((Object)new MetricDescriptor("Comment Completeness Assessment", "An assessment for the completeness of the interface documentation. The assessment is independent of findings being tolerated or not."));
    private final CodeScopeAware<MetricDescriptor> methodCommentCompletenessAssessment = CodeScopeAware.defaultCodeScopeWithValue((Object)new MetricDescriptor("Comment Completeness Assessment for Methods", "An assessment for the completeness of the interface documentation for methods. The assessment is independent of findings being tolerated or not.", false));
    private final CodeScopeAware<MetricDescriptor> attributesCommentCompletenessAssessment = CodeScopeAware.defaultCodeScopeWithValue((Object)new MetricDescriptor("Comment Completeness Assessment for Attributes", "An assessment for the completeness of the interface documentation for attributes. The assessment is independent of findings being tolerated or not.", false));
    private final CodeScopeAware<MetricDescriptor> typeCommentCompletenessAssessment = CodeScopeAware.defaultCodeScopeWithValue((Object)new MetricDescriptor("Comment Completeness Assessment for Types", "An assessment for the completeness of the interface documentation for types. The assessment is independent of findings being tolerated or not.", false));
    private final CodeScopeAware<MetricDescriptor> commentTypeMetrics = CodeScopeAware.defaultCodeScopeWithValue((Object)new MetricDescriptor("Comment type metrics", "Additional metrics that provide the ratio of different comment types. This adds a lot of metrics.", false, ConfigExposed.EConfigVisibility.ADVANCED));
    private final CodeScopeAware<FindingDescriptor> interfaceCommentCompletenessFinding = CodeScopeAware.defaultCodeScopeWithValue((Object)new FindingDescriptor("Interface comment completeness", EAnalysisTool.TEAMSCALE, CommentCompletenessAnalyzerBase.SUPPORTED_LANGUAGES, EFindingEnablement.YELLOW, (String)CheckDescriptionLoader.getCheckDescription(((Object)((Object)this)).getClass(), (String)"cqse-interface-comment-completeness.md").orElseThrow()));
    @ConfigExposed(name="Interface comments must be doc comments", description="Whether a comment must be a doc comment (e.g. JavaDoc) to be counted in the interface comment completeness findings.")
    private CodeScopeAware<Boolean> interfaceCommentsMustBeDocComments = CodeScopeAware.defaultCodeScopeWithValue((Object)true);
    @ConfigExposed(name="Task tag pattern", description="Regex pattern for finding task tags in the code. If not specified defaults to:\n`(?i)(^|(?<=\\W))TODO(\\b|\\W).*`\nTo ignore task tags which, e.g. reference an issue in an issue tracker, use the \"Task tag exclusion pattern\"", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    private CodeScopeAware<String> taskTagPattern = CodeScopeAware.defaultCodeScopeWithValue((Object)"");
    @ConfigExposed(name="Task tag exclusion pattern", description="Regex pattern to ignore task tags previously matched by the \"Task tag pattern\".To ignore task tags which reference an issue in an issue tracker, use a variation of this pattern (this will, e.g., ignore comments containing text like \"ABC-1234\"):\n`[A-Z]+-[0-9]+`", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    private CodeScopeAware<String> taskTagExclusionPattern = CodeScopeAware.defaultCodeScopeWithValue((Object)"");
    @ConfigExposed(name="Problem tag pattern", description="Regex pattern for finding problem tags in the code. If not specified defaults to:\n`(?i)(^|(?<=\\W))(FIXME|HACK)(\\b|\\W).*`\nTo ignore problem tags which, e.g. reference an issue in an issue tracker, use the \"Problem tag exclusion pattern\"", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    private CodeScopeAware<String> problemTagPattern = CodeScopeAware.defaultCodeScopeWithValue((Object)"");
    @ConfigExposed(name="Problem tag exclusion pattern", description="Regex pattern to ignore problem tags previously matched by the \"Problem tag pattern\".To ignore problem tags which reference an issue in an issue tracker, use a variation of this pattern (this will, e.g., ignore comments containing text like \"ABC-1234\"):\n`[A-Z]+-[0-9]+`", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    private CodeScopeAware<String> problemTagExclusionPattern = CodeScopeAware.defaultCodeScopeWithValue((Object)"");
    @ConfigExposed(name="Combine adjacent line comments", description="This option controls whether multiple adjacent line comments are combined and analyzed as one comment. For example, see this comment:\n```\n// HACK with a very long description\n// that spans over multiple lines\n// And finally the pattern that matches\n// the exclusion pattern: ABC-1234\n```\nIf this option is disabled, the line-comments are all analyzed one by one, creating a finding for the first line.\nIf this option is enabled, the line-comments are analyzed as one entity, and in case a respective exclusion pattern is configured that matches \"ABC-1234\", no finding is created.\n")
    private CodeScopeAware<Boolean> combineAdjacentLineComments = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @ConfigExposed(name="Comments allowed inside the method", description="Whether a comment can appear inside the method definition to be counted in the interface comment completeness findings. This is always the case for Python code.")
    private CodeScopeAware<Boolean> allowCommentInside = CodeScopeAware.defaultCodeScopeWithValue((Object)false);
    @ConfigExposed(name="Required interface comments", validator=EntitySelectionExpressionValidator.class, description="Selector expression that describes the code elements that require an interface comment.", multilineText=true)
    private CodeScopeAware<String> interfaceCommentCompletenessSelector = CodeScopeAware.defaultCodeScopeWithValue((Object)"public & (type | method | attribute) & !(simpleGetter | simpleSetter | annotated(Override) | override)");
    private final CodeScopeAware<FindingDescriptor> unrelatedInterfaceCommentFinding = CodeScopeAware.defaultCodeScopeWithValue((Object)new FindingDescriptor("Unrelated interface comment", EAnalysisTool.TEAMSCALE, CommentClassificationAnalysisBase.getSupportedLanguages(), EFindingEnablement.YELLOW, (String)CheckDescriptionLoader.getCheckDescription(((Object)((Object)this)).getClass(), (String)"cqse-unrelated-interface-comment.md").orElseThrow()));
    private final CodeScopeAware<FindingDescriptor> trivialInterfaceCommentFinding = CodeScopeAware.defaultCodeScopeWithValue((Object)new FindingDescriptor("Trivial interface comment", EAnalysisTool.TEAMSCALE, CommentClassificationAnalysisBase.getSupportedLanguages(), EFindingEnablement.OFF, (String)CheckDescriptionLoader.getCheckDescription(((Object)((Object)this)).getClass(), (String)"cqse-trivial-interface-comment.md").orElseThrow()));
    private final CodeScopeAware<FindingDescriptor> emptyInterfaceCommentFinding = CodeScopeAware.defaultCodeScopeWithValue((Object)new FindingDescriptor("Empty interface comment", EAnalysisTool.TEAMSCALE, CommentClassificationAnalysisBase.getSupportedLanguages(), EFindingEnablement.YELLOW, (String)CheckDescriptionLoader.getCheckDescription(((Object)((Object)this)).getClass(), (String)"cqse-empty-interface-comment.md").orElseThrow()));
    private final CodeScopeAware<FindingDescriptor> shortInlineCommentFinding = CodeScopeAware.defaultCodeScopeWithValue((Object)new FindingDescriptor("Short inline comment", EAnalysisTool.TEAMSCALE, CommentClassificationAnalysisBase.getSupportedLanguages(), EFindingEnablement.OFF, (String)CheckDescriptionLoader.getCheckDescription(((Object)((Object)this)).getClass(), (String)"cqse-short-inline-comment.md").orElseThrow()));
    private final CodeScopeAware<FindingDescriptor> longInlineCommentFinding = CodeScopeAware.defaultCodeScopeWithValue((Object)new FindingDescriptor("Long inline comment", EAnalysisTool.TEAMSCALE, CommentClassificationAnalysisBase.getSupportedLanguages(), EFindingEnablement.OFF, (String)CheckDescriptionLoader.getCheckDescription(((Object)((Object)this)).getClass(), (String)"cqse-long-inline-comment.md").orElseThrow()));
    private final CodeScopeAware<FindingDescriptor> exclamationQuestionMarkCommentFinding = CodeScopeAware.defaultCodeScopeWithValue((Object)new FindingDescriptor("Comment with exclamation or question mark", EAnalysisTool.TEAMSCALE, CommentClassificationAnalysisBase.getSupportedLanguages(), EFindingEnablement.OFF, (String)CheckDescriptionLoader.getCheckDescription(((Object)((Object)this)).getClass(), (String)"cqse-exclamation-question-mark-comment.md").orElseThrow()));
    private final CodeScopeAware<FindingDescriptor> taskTagFinding = CodeScopeAware.defaultCodeScopeWithValue((Object)new FindingDescriptor("Task tags", EAnalysisTool.TEAMSCALE, EnumSet.allOf(ELanguage.class), EFindingEnablement.YELLOW, (String)CheckDescriptionLoader.getCheckDescription(((Object)((Object)this)).getClass(), (String)"cqse-task-tags.md").orElseThrow()));
    private final CodeScopeAware<FindingDescriptor> problemTagFinding = CodeScopeAware.defaultCodeScopeWithValue((Object)new FindingDescriptor("Problem tags", EAnalysisTool.TEAMSCALE, EnumSet.allOf(ELanguage.class), EFindingEnablement.RED, (String)CheckDescriptionLoader.getCheckDescription(((Object)((Object)this)).getClass(), (String)"cqse-problem-tags.md").orElseThrow()));

    public void configureProject(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        this.createTrigger(proxy);
        this.createMetrics(proxy);
        for (CodeScope codeScope : proxy.getCodeScopes()) {
            this.createFindingSchemaEntries(proxy, codeScope.getName());
        }
    }

    private void createTrigger(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        TriggerBuilder trigger = new TriggerBuilder(CommentAnalysis.class, ETriggerConcurrency.PARALLEL);
        trigger.setTriggerParameter("comment-completeness.selector", this.interfaceCommentCompletenessSelector);
        trigger.setTriggerParameter("comment-completeness.doc-comment", this.interfaceCommentsMustBeDocComments);
        trigger.setTriggerParameter("comment-inside.allow", this.allowCommentInside);
        this.configureProblemAndTaskTagParameter(trigger);
        this.registerCommentRatioMetricsEnablement(trigger);
        this.registerCommentTypeMetricsEnablement(trigger);
        this.registerCommentCompletenessEnablement(trigger);
        this.registerCommentClassificationEnablement(trigger);
        trigger.setMetricEnablementParameter("comment-completeness-assessment.enabled", this.commentCompletenessAssessment);
        trigger.setMetricEnablementParameter("comment-completeness-assessment-for-types.enabled", this.typeCommentCompletenessAssessment);
        trigger.setMetricEnablementParameter("comment-completeness-assessment-for-methods.enabled", this.methodCommentCompletenessAssessment);
        trigger.setMetricEnablementParameter("comment-completeness-assessment-for-attributes.enabled", this.attributesCommentCompletenessAssessment);
        proxy.createTrigger(trigger);
    }

    private void registerCommentRatioMetricsEnablement(TriggerBuilder trigger) {
        CodeScopeAware commentRatioMetricEnabled = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : this.commentRatioMetric.getCodeScopeNames()) {
            commentRatioMetricEnabled.setValue(codeScopeName, (Object)String.valueOf(((MetricDescriptor)this.commentRatioMetric.getValue(codeScopeName)).isMetricEnabled()));
        }
        trigger.setTriggerParameter("comment-ratio-metric.enabled", (ITriggerParameter)commentRatioMetricEnabled);
    }

    private void registerCommentTypeMetricsEnablement(TriggerBuilder trigger) {
        CodeScopeAware commentTypeMetricsEnabled = CodeScopeAware.empty();
        for (CodeScopeName codeScopeName : this.commentTypeMetrics.getCodeScopeNames()) {
            commentTypeMetricsEnabled.setValue(codeScopeName, (Object)String.valueOf(((MetricDescriptor)this.commentTypeMetrics.getValue(codeScopeName)).isMetricEnabled()));
        }
        trigger.setTriggerParameter("comment-type-metrics.enabled", (ITriggerParameter)commentTypeMetricsEnabled);
    }

    private void registerCommentCompletenessEnablement(TriggerBuilder trigger) {
        CodeScopeAware commentCompletenessAnalysisEnabled = CodeScopeAware.empty();
        Iterator iterator = this.interfaceCommentCompletenessFinding.getCodeScopeNames().iterator();
        while (iterator.hasNext()) {
            CodeScopeName codeScope;
            commentCompletenessAnalysisEnabled.setValue(codeScope, (Object)String.valueOf(CommentAnalysisConfiguration.isFindingEnabled(this.interfaceCommentCompletenessFinding, codeScope = (CodeScopeName)iterator.next()) || ((MetricDescriptor)this.commentCompletenessAssessment.getValue(codeScope)).isMetricEnabled()));
        }
        trigger.setTriggerParameter("comment-completeness-analysis.enabled", (ITriggerParameter)commentCompletenessAnalysisEnabled);
    }

    private void registerCommentClassificationEnablement(TriggerBuilder trigger) {
        CodeScopeAware commentClassificationEnabled = CodeScopeAware.empty();
        Iterator iterator = this.unrelatedInterfaceCommentFinding.getCodeScopeNames().iterator();
        while (iterator.hasNext()) {
            CodeScopeName codeScope;
            commentClassificationEnabled.setValue(codeScope, (Object)String.valueOf(CommentAnalysisConfiguration.isFindingEnabled(this.unrelatedInterfaceCommentFinding, codeScope = (CodeScopeName)iterator.next()) || CommentAnalysisConfiguration.isFindingEnabled(this.trivialInterfaceCommentFinding, codeScope) || CommentAnalysisConfiguration.isFindingEnabled(this.shortInlineCommentFinding, codeScope) || CommentAnalysisConfiguration.isFindingEnabled(this.longInlineCommentFinding, codeScope) || CommentAnalysisConfiguration.isFindingEnabled(this.emptyInterfaceCommentFinding, codeScope) || CommentAnalysisConfiguration.isFindingEnabled(this.exclamationQuestionMarkCommentFinding, codeScope) || CommentAnalysisConfiguration.isFindingEnabled(this.commentedCodeFinding, codeScope)));
        }
        trigger.setTriggerParameter("comment-classification.enabled", (ITriggerParameter)commentClassificationEnabled);
    }

    private void configureProblemAndTaskTagParameter(TriggerBuilder trigger) {
        CodeScopeAware<String> taskAnalysisEnabled = CommentAnalysisConfiguration.getAnalysisEnablementPerCodeScope(this.taskTagFinding);
        trigger.setTriggerParameter("task-tags-search.enabled", taskAnalysisEnabled);
        trigger.setTriggerParameter("task-tag.pattern", this.taskTagPattern);
        trigger.setTriggerParameter("task-tag.exclusion-pattern", this.taskTagExclusionPattern);
        CodeScopeAware<String> problemTagAnalysisEnabled = CommentAnalysisConfiguration.getAnalysisEnablementPerCodeScope(this.problemTagFinding);
        trigger.setTriggerParameter("problem-tags-search.enabled", problemTagAnalysisEnabled);
        trigger.setTriggerParameter("problem-tag.pattern", this.problemTagPattern);
        trigger.setTriggerParameter("problem-tag.exclusion-pattern", this.problemTagExclusionPattern);
        trigger.setTriggerParameter("task-problem-tag.combine-adjacent-line-comments", this.combineAdjacentLineComments);
    }

    private static @NonNull CodeScopeAware<String> getAnalysisEnablementPerCodeScope(CodeScopeAware<FindingDescriptor> findingDescriptorPerCodeScope) {
        CodeScopeAware analysisEnabled = CodeScopeAware.empty();
        for (CodeScopeName codeScope : findingDescriptorPerCodeScope.getCodeScopeNames()) {
            analysisEnabled.setValue(codeScope, (Object)String.valueOf(CommentAnalysisConfiguration.isFindingEnabled(findingDescriptorPerCodeScope, codeScope)));
        }
        return analysisEnabled;
    }

    private static boolean isFindingEnabled(CodeScopeAware<FindingDescriptor> findingDescriptor, CodeScopeName codeScope) {
        return ((FindingDescriptor)findingDescriptor.getValue(codeScope)).getEnablement().isEnabled();
    }

    private void createMetrics(ProjectCreationProxy proxy) throws ProjectConfigurationException {
        MetricSchemaProxy schema = proxy.getCodeMetricSchema();
        this.createCharacterCommentMetrics(schema);
        this.createCommentCompletenessMetrics(schema, (Set)proxy.getConfiguredLanguages().getValueForDefaultCodeScope());
    }

    private void createCommentCompletenessMetrics(MetricSchemaProxy schema, Set<ELanguage> languages) throws ProjectConfigurationException {
        if (!CommentAnalysisConfiguration.isCommentCompletenessSupported(languages)) {
            return;
        }
        String commentCompleteness = "comment-completeness";
        if (CodeScopeUtils.isMetricEnabled(this.commentCompletenessAssessment)) {
            schema.addMetric(commentCompleteness, schema.createMetricIndexSource(commentCompleteness), ((MetricDescriptor)this.commentCompletenessAssessment.getValueForDefaultCodeScope()).getName(), ((MetricDescriptor)this.commentCompletenessAssessment.getValueForDefaultCodeScope()).getDescription(), EMetricValueType.ASSESSMENT, MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[0]);
        }
        if (CodeScopeUtils.isMetricEnabled(this.methodCommentCompletenessAssessment)) {
            CommentAnalysisConfiguration.addCommentMetricForElement(schema, "comment-completeness-methods", ((MetricDescriptor)this.methodCommentCompletenessAssessment.getValueForDefaultCodeScope()).getName(), ((MetricDescriptor)this.methodCommentCompletenessAssessment.getValueForDefaultCodeScope()).getDescription());
        }
        if (CodeScopeUtils.isMetricEnabled(this.attributesCommentCompletenessAssessment)) {
            CommentAnalysisConfiguration.addCommentMetricForElement(schema, "comment-completeness-attributes", ((MetricDescriptor)this.attributesCommentCompletenessAssessment.getValueForDefaultCodeScope()).getName(), ((MetricDescriptor)this.attributesCommentCompletenessAssessment.getValueForDefaultCodeScope()).getDescription());
        }
        if (CodeScopeUtils.isMetricEnabled(this.typeCommentCompletenessAssessment)) {
            CommentAnalysisConfiguration.addCommentMetricForElement(schema, "comment-completeness-types", ((MetricDescriptor)this.typeCommentCompletenessAssessment.getValueForDefaultCodeScope()).getName(), ((MetricDescriptor)this.typeCommentCompletenessAssessment.getValueForDefaultCodeScope()).getDescription());
        }
    }

    private static void addCommentMetricForElement(MetricSchemaProxy schema, String metricName, String displayName, String displayDescription) throws ProjectConfigurationException {
        schema.addMetric(metricName, schema.createMetricIndexSource(metricName), displayName, displayDescription, EMetricValueType.ASSESSMENT, MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[0]);
    }

    private void createCharacterCommentMetrics(MetricSchemaProxy schema) throws ProjectConfigurationException {
        String[] commentMetricNames = new String[]{"comment-chars", "code-chars", "comment-chars-type", "comment-copyright-chars", "comment-header-chars", "comment-interface-chars", "comment-inline-chars", "comment-section-chars", "comment-task-chars", "commented-code-chars"};
        for (int i = 0; i < commentMetricNames.length; ++i) {
            String name = commentMetricNames[i];
            String readableName = name.replace("-", " ");
            schema.addMetric(name, schema.createMetricIndexSource(name), readableName, readableName, EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.SUM, new EMetricProperty[]{EMetricProperty.HIDDEN});
            if (i == 1 && CodeScopeUtils.isMetricEnabled(this.commentRatioMetric)) {
                schema.addMetric("comment-ratio", schema.createDivisionMetricSource("comment-chars", "code-chars", CodeScopeUtils.getCodeScopesWithDisabledMetric(this.commentRatioMetric)), "Comment Ratio", "Comment ratio based on character count", EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.NONE, new EMetricProperty[]{EMetricProperty.RATIO_METRIC, EMetricProperty.LOW_IS_BAD});
            }
            if (i < 2 || !CodeScopeUtils.isMetricEnabled(this.commentTypeMetrics)) continue;
            this.createSpecificCommentRatioMetric(schema, name);
        }
    }

    private void createSpecificCommentRatioMetric(MetricSchemaProxy schema, String name) throws ProjectConfigurationException {
        schema.addMetric(name + "-ratio", schema.createDivisionMetricSource(name, "comment-chars-type", CodeScopeUtils.getCodeScopesWithDisabledMetric(this.commentTypeMetrics)), "Comment: " + name.substring(8) + " ratio", "Ratio of chars in " + name.substring(7) + " comments relative to overall comments", EMetricValueType.NUMERIC, MetricDirectorySchemaEntry.EAggregation.NONE, new EMetricProperty[]{EMetricProperty.RATIO_METRIC, EMetricProperty.QUALITY_NEUTRAL});
    }

    private void createFindingSchemaEntries(ProjectCreationProxy proxy, CodeScopeName codeScopeName) {
        proxy.addFindingsSchemaEntry("Comments", "Missing Interface Comment", (FindingDescriptor)this.interfaceCommentCompletenessFinding.getValue(codeScopeName), codeScopeName);
        proxy.addFindingsSchemaEntry("Comments", "Unrelated Member Comment", (FindingDescriptor)this.unrelatedInterfaceCommentFinding.getValue(codeScopeName), codeScopeName);
        proxy.addFindingsSchemaEntry("Comments", "Trivial Member Comment", (FindingDescriptor)this.trivialInterfaceCommentFinding.getValue(codeScopeName), codeScopeName);
        proxy.addFindingsSchemaEntry("Comments", "Empty Interface Comment", (FindingDescriptor)this.emptyInterfaceCommentFinding.getValue(codeScopeName), codeScopeName);
        proxy.addFindingsSchemaEntry("Comments", "Short Inline Comment", (FindingDescriptor)this.shortInlineCommentFinding.getValue(codeScopeName), codeScopeName);
        proxy.addFindingsSchemaEntry("Comments", "Long Inline Comment", (FindingDescriptor)this.longInlineCommentFinding.getValue(codeScopeName), codeScopeName);
        proxy.addFindingsSchemaEntry("Comments", "Exclamation or Question Mark in Comment", (FindingDescriptor)this.exclamationQuestionMarkCommentFinding.getValue(codeScopeName), codeScopeName);
        proxy.addFindingsSchemaEntry("Comments", "Task Tags", (FindingDescriptor)this.taskTagFinding.getValue(codeScopeName), codeScopeName);
        proxy.addFindingsSchemaEntry("Comments", "Problem Tags", (FindingDescriptor)this.problemTagFinding.getValue(codeScopeName), codeScopeName);
        proxy.addFindingsSchemaEntry("Comments", "Commented Out Code", (FindingDescriptor)this.commentedCodeFinding.getValue(codeScopeName), codeScopeName);
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        template.registerConfiguration((AnalysisConfigurationBase)this);
        CodeScopeName codeScopeName = template.getCodeScope();
        this.autoExpose(codeScopeName);
        if (CommentAnalysisConfiguration.isOnlySelectedLanguage(ELanguage.CPP, languages) || CommentAnalysisConfiguration.isOnlySelectedLanguage(ELanguage.CPP_MS_CLI, languages) || CommentAnalysisConfiguration.isOnlySelectedLanguage(ELanguage.C, languages)) {
            this.setSelectorForInterfaceComments(CPP_HEADER_COMMENTING_STYLE_SELECTOR_EXPRESSION, codeScopeName);
        } else if (CommentAnalysisConfiguration.isOnlySelectedLanguage(ELanguage.JAVASCRIPT, languages)) {
            this.setSelectorForInterfaceComments(JAVASCRIPT_DEFAULT_SELECTOR_EXPRESSION, codeScopeName);
        } else if (CommentAnalysisConfiguration.isOnlySelectedLanguage(ELanguage.CS, languages)) {
            this.setSelectorForInterfaceComments(CS_DEFAULT_SELECTOR_EXPRESSION, codeScopeName);
        } else if (CommentAnalysisConfiguration.isOnlySelectedLanguage(ELanguage.ABAP, languages)) {
            this.setSelectorForInterfaceComments(ABAP_DEFAULT_SELECTOR_EXPRESSION, codeScopeName);
        } else if (languages.contains(ELanguage.PYTHON)) {
            this.setSelectorForInterfaceCommentsPython(languages, codeScopeName);
        }
        this.registerCommentCompletenessGroup(template, languages);
        if (CommentAnalysisConfiguration.isCommentClassificationSupported(languages)) {
            this.registerCommentClassificationItems(template, codeScopeName);
        }
        template.registerConfigurationItemsCodeScopeAware("Task Tags", "Documentation", Arrays.asList(this.getOptionForField("combineAdjacentLineComments", codeScopeName), (ConfigurationItemBase)this.taskTagFinding.getValue(codeScopeName), this.getOptionForField("taskTagPattern", codeScopeName), this.getOptionForField("taskTagExclusionPattern", codeScopeName), (ConfigurationItemBase)this.problemTagFinding.getValue(codeScopeName), this.getOptionForField("problemTagPattern", codeScopeName), this.getOptionForField("problemTagExclusionPattern", codeScopeName)));
    }

    private void registerCommentClassificationItems(ConfigurationTemplate template, CodeScopeName codeScopeName) {
        template.registerConfigurationItemsCodeScopeAware("Comment Quality", "Documentation", Arrays.asList((ConfigurationItemBase)this.unrelatedInterfaceCommentFinding.getValue(codeScopeName), (ConfigurationItemBase)this.trivialInterfaceCommentFinding.getValue(codeScopeName), (ConfigurationItemBase)this.emptyInterfaceCommentFinding.getValue(codeScopeName), (ConfigurationItemBase)this.shortInlineCommentFinding.getValue(codeScopeName), (ConfigurationItemBase)this.longInlineCommentFinding.getValue(codeScopeName), (ConfigurationItemBase)this.exclamationQuestionMarkCommentFinding.getValue(codeScopeName)));
        template.registerConfigurationItemsCodeScopeAware("Bad Practice", "Comprehensibility", Collections.singleton((ConfigurationItemBase)this.commentedCodeFinding.getValue(codeScopeName)));
    }

    private static boolean isCommentClassificationSupported(Set<ELanguage> languages) {
        return languages.stream().anyMatch(CommentClassificationAnalysisBase::isSupportedLanguage);
    }

    public static boolean isCommentClassificationSupportedFromStringSet(Set<String> languages) {
        return languages.stream().anyMatch(CommentClassificationAnalysisBase::isSupportedLanguage);
    }

    private static boolean isCommentCompletenessSupported(Set<ELanguage> languages) {
        return !CollectionUtils.intersectionSet(CommentCompletenessAnalyzerBase.SUPPORTED_LANGUAGES, (Collection[])new Collection[]{languages}).isEmpty();
    }

    private void setSelectorForInterfaceComments(String selector, CodeScopeName codeScopeName) {
        try {
            ConfigOptionDescriptorBase interfaceCommentCompletenessSelectorOption = this.getOptionForField("interfaceCommentCompletenessSelector", codeScopeName);
            interfaceCommentCompletenessSelectorOption.setValueAndDefaultValue(selector, codeScopeName);
        }
        catch (ProjectConfigurationException e) {
            CCSMAssert.fail((String)("Unexpected exception: " + String.valueOf((Object)e)));
        }
    }

    private void registerCommentCompletenessGroup(ConfigurationTemplate template, Set<ELanguage> languages) {
        CodeScopeName codeScopeName = template.getCodeScope();
        if (CommentAnalysisConfiguration.isCommentCompletenessSupported(languages)) {
            ArrayList<Object> items = new ArrayList<Object>();
            if (languages.contains(ELanguage.MATLAB)) {
                items.add(this.getOptionForField("allowCommentInside", codeScopeName));
            }
            items.add((ConfigurationItemBase)this.interfaceCommentCompletenessFinding.getValue(codeScopeName));
            items.add(this.getOptionForField("interfaceCommentCompletenessSelector", codeScopeName));
            items.add(this.getOptionForField("interfaceCommentsMustBeDocComments", codeScopeName));
            items.add((ConfigurationItemBase)this.commentCompletenessAssessment.getValue(codeScopeName));
            if (EFeatureToggle.AUDIT_FEATURES.isEnabled()) {
                items.add((ConfigurationItemBase)this.typeCommentCompletenessAssessment.getValue(codeScopeName));
                items.add((ConfigurationItemBase)this.methodCommentCompletenessAssessment.getValue(codeScopeName));
                items.add((ConfigurationItemBase)this.attributesCommentCompletenessAssessment.getValue(codeScopeName));
            }
            template.registerConfigurationItemsCodeScopeAware("Comment Completeness", "Documentation", items);
        }
        if (CommentAnalysisConfiguration.isCommentClassificationSupported(languages)) {
            template.registerConfigurationItemsCodeScopeAware("Comment Completeness", "Documentation", List.of((ConfigurationItemBase)this.commentTypeMetrics.getValue(codeScopeName)));
        }
        template.registerConfigurationItemsCodeScopeAware("Comment Completeness", "Documentation", List.of((ConfigurationItemBase)this.commentRatioMetric.getValue(codeScopeName)));
    }

    private void setSelectorForInterfaceCommentsPython(Set<ELanguage> languages, CodeScopeName codeScopeName) {
        if (languages.size() == 1) {
            this.setSelectorForInterfaceComments(PYTHON_DEFAULT_SELECTOR_EXPRESSION, codeScopeName);
        } else {
            String selector = (String)this.interfaceCommentCompletenessSelector.getValueWithDefault(codeScopeName);
            String selectorWithPythonHandling = "(" + selector + ") | (language(PYTHON) & (type | method))";
            this.setSelectorForInterfaceComments(selectorWithPythonHandling, codeScopeName);
        }
    }

    private static boolean isOnlySelectedLanguage(ELanguage givenLanguage, Set<ELanguage> configuredLanguages) {
        return configuredLanguages.size() == 1 && configuredLanguages.contains(givenLanguage);
    }
}

