/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.engine.index.shared.CodeScopeName;

public class FxCopConfiguration
extends ToolConfigurationBase {
    private static final String QUALITY_INDICATOR_NAME = "Code Anomalies";
    private static final String DESCRIPTIONS_PATH = "fxcop";
    public static final String FXCOP_RULES_MAPPINGS_TSV = "message/fxcop/check-mappings.tsv";
    public static final String CATEGORY_NAME = "FxCop";
    public static final String RULE_PREFIX = "CA";
    private static final Pattern CHECK_ID_EXTRACTION_PATTERN = Pattern.compile(".*?\\((.*)?\\)");

    public FxCopConfiguration() throws ProjectConfigurationException {
        super(EAnalysisTool.FXCOP, CATEGORY_NAME, DESCRIPTIONS_PATH, FXCOP_RULES_MAPPINGS_TSV, "");
        this.autoExpose();
    }

    protected Set<ELanguage> determineLanguages(String ruleId) {
        return Set.of(ELanguage.CS);
    }

    protected String determineQualityIndicator(String groupName, CodeScopeName codeScopeName) {
        return QUALITY_INDICATOR_NAME;
    }

    protected String getDescriptionFileName(String ruleId) {
        return super.getDescriptionFileName(CHECK_ID_EXTRACTION_PATTERN.matcher(ruleId).replaceFirst("$1"));
    }
}

