/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.configuration.tools;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.core.analysis.configuration.ConfigurationTemplate;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.model.AnalysisConfigurationBase;
import com.teamscale.core.analysis.configuration.model.EAnalysisTool;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.analysis.configuration.model.ToolConfigurationBase;
import eu.cqse.check.framework.core.EFindingEnablement;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.LanguageGroups;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.lib.commons.regex.Patterns;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.resources.ResourceException;
import org.conqat.lib.commons.string.StringUtils;

public class PCLintConfiguration
extends ToolConfigurationBase {
    public static final String CATEGORY_NAME = "pclint";
    private static final String PC_LINT_RULES_FILE = "pc-lint/msg.json";

    public PCLintConfiguration() {
        super(EAnalysisTool.PC_LINT, CATEGORY_NAME);
        this.declareCodeScopeAware();
    }

    private void registerRuleAsFinding(PCLintRule rule, CodeScopeName codeScopeName) {
        int ruleId = Integer.parseInt(rule.id);
        rule.text = StringUtils.replaceAll((String)rule.text, (Pattern)Patterns.WHITESPACE, (String)" ");
        String findingName = "Rule " + ruleId + ": " + rule.text;
        String findingDescription = rule.commentary + " (PC-lint rule " + ruleId + ")";
        FindingDescriptor finding = new FindingDescriptor(findingName, EAnalysisTool.PC_LINT, (Set)LanguageGroups.C_CPP_AND_MS_CLI, PCLintConfiguration.determineColor(ruleId), findingDescription);
        finding.setPropertyDescription("Rule ID", "The PC-lint rule ID");
        this.registerFinding(finding, this.getGroup(PCLintConfiguration.determineGroupName(ruleId)), rule.id, codeScopeName);
    }

    private static String determineGroupName(int ruleId) {
        String language = " (C)";
        if (PCLintConfiguration.isCppRule(ruleId)) {
            ruleId -= 1000;
            language = " (C++)";
        }
        if (ruleId < 200) {
            return "PC-lint syntax errors" + language;
        }
        if (ruleId < 300) {
            return "PC-lint internal errors" + language;
        }
        if (ruleId < 400) {
            return "PC-lint fatal errors" + language;
        }
        if (ruleId < 700) {
            return "PC-lint warnings" + language;
        }
        if (ruleId < 900) {
            return "PC-lint informational" + language;
        }
        return "PC-lint notes" + language;
    }

    private static EFindingEnablement determineColor(int ruleId) {
        if (PCLintConfiguration.isCppRule(ruleId)) {
            ruleId -= 1000;
        }
        if (ruleId < 400) {
            return EFindingEnablement.RED;
        }
        if (ruleId < 700) {
            return EFindingEnablement.YELLOW;
        }
        return EFindingEnablement.OFF;
    }

    private static boolean isCppRule(int ruleId) {
        return ruleId > 1000 && ruleId < 2000;
    }

    protected String determineQualityIndicator(String groupName, CodeScopeName codeScopeName) {
        if (groupName.contains("error") || groupName.contains("warn")) {
            return super.determineQualityIndicator(groupName, codeScopeName);
        }
        return null;
    }

    public void registerQualityIndicators(ConfigurationTemplate template, Set<ELanguage> languages, Set<EAnalysisTool> tools) throws ProjectConfigurationException {
        if (LanguageGroups.C_CPP_AND_MS_CLI.stream().noneMatch(languages::contains) || !tools.contains(EAnalysisTool.PC_LINT)) {
            return;
        }
        try {
            for (PCLintRule rule : PCLintConfiguration.loadRules()) {
                this.registerRuleAsFinding(rule, template.getCodeScope());
            }
        }
        catch (ConQATException | ResourceException e) {
            throw new ProjectConfigurationException(e);
        }
        catch (NumberFormatException e) {
            throw new ProjectConfigurationException("Invalid (non-numeric) rule ID!", (Throwable)e);
        }
        super.registerQualityIndicators(template, languages, tools);
        template.registerConfiguration((AnalysisConfigurationBase)this);
    }

    private static PCLintRule[] loadRules() throws ConQATException {
        String content = Resource.of(PCLintConfiguration.class, (String)PC_LINT_RULES_FILE).getContent();
        return (PCLintRule[])JsonUtils.deserializeFromJsonWithNullCheck((String)content, PCLintRule[].class);
    }

    private static final class PCLintRule {
        @JsonProperty(value="TEXT")
        public String text;
        @JsonProperty(value="ID")
        public String id;
        @JsonProperty(value="COMMENTARY")
        public String commentary;

        private PCLintRule() {
        }
    }
}

