/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow;

import com.teamscale.index.dataflow.ArithmeticExpressionTokenUtils;
import com.teamscale.index.dataflow.AssignmentTokenMarker;
import com.teamscale.index.dataflow.division_by_zero.AdvancedIntVariableWriteHeuristic;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public class IntegerArithmeticExpressionEvaluator {
    public static Optional<Integer> evaluateIntegerArithmeticExpression(List<IToken> tokens, Map<String, Integer> statesByVariableName, Map<String, Integer> writesResolved) {
        if (!IntegerArithmeticExpressionEvaluator.allVariablesAndLiteralsResolved(tokens, statesByVariableName)) {
            return Optional.empty();
        }
        if ((tokens = ArithmeticExpressionTokenUtils.filterTokens(tokens)).isEmpty() || !ArithmeticExpressionTokenUtils.allParenthesesAreBalanced(tokens) || AdvancedIntVariableWriteHeuristic.containsPointerOrAddressOperator(tokens)) {
            return Optional.empty();
        }
        if (TokenStreamUtils.containsAny(tokens = ArithmeticExpressionTokenUtils.replaceAssignments(tokens, writesResolved), AdvancedIntVariableWriteHeuristic.ASSIGNMENT_OPERATORS)) {
            return Optional.empty();
        }
        tokens = IntegerArithmeticExpressionEvaluator.resolveVariables(tokens, statesByVariableName, writesResolved);
        tokens = IntegerArithmeticExpressionEvaluator.resolveUnaryOperators(tokens);
        tokens = IntegerArithmeticExpressionEvaluator.toPostfix(tokens);
        try {
            return IntegerArithmeticExpressionEvaluator.evaluateExpression(tokens, statesByVariableName);
        }
        catch (ArithmeticException | NumberFormatException e) {
            return Optional.empty();
        }
    }

    public static Optional<Integer> evaluateIntegerArithmeticExpression(List<IToken> tokens, Map<String, Integer> statesByVariableName) {
        HashMap<String, Integer> writesResolved = new HashMap<String, Integer>();
        return IntegerArithmeticExpressionEvaluator.evaluateIntegerArithmeticExpression(tokens, statesByVariableName, writesResolved);
    }

    private static boolean allVariablesAndLiteralsResolved(List<IToken> tokens, Map<String, Integer> statesByVariableName) {
        if (TokenStreamUtils.containsAny(tokens, (ETokenType[])new ETokenType[]{ETokenType.VALUE, ETokenType.THIS})) {
            return false;
        }
        int lastAssignmentIndex = TokenStreamUtils.lastTokenMatching(tokens, (ITokenMatcher)ETokenType.EQ) + 1;
        List<IToken> relevantExpressionPart = tokens.subList(lastAssignmentIndex, tokens.size());
        Set variables = relevantExpressionPart.stream().filter(token -> token.getType() == ETokenType.IDENTIFIER).map(IToken::getText).collect(Collectors.toSet());
        for (String variable : variables) {
            if (statesByVariableName.get(variable) != null) continue;
            return false;
        }
        return tokens.stream().filter(token -> token.getType().isLiteral()).allMatch(token -> AdvancedIntVariableWriteHeuristic.canGetIntegerFromString(token.getText()));
    }

    private static List<IToken> toPostfix(List<IToken> tokens) {
        Stack<IToken> operatorStack = new Stack<IToken>();
        ArrayList<IToken> outputQueue = new ArrayList<IToken>();
        for (IToken token : tokens) {
            ETokenType type = token.getType();
            if (type.isLiteral()) {
                outputQueue.add(token);
                continue;
            }
            if (type.isOperator()) {
                IntegerArithmeticExpressionEvaluator.addOperatorToOperatorStack(token, type, operatorStack, outputQueue);
                continue;
            }
            if (type == ETokenType.LPAREN) {
                operatorStack.push(token);
                continue;
            }
            if (type != ETokenType.RPAREN) continue;
            IntegerArithmeticExpressionEvaluator.closeParentheses(operatorStack, outputQueue);
        }
        while (!operatorStack.empty()) {
            outputQueue.add((IToken)operatorStack.pop());
        }
        return outputQueue;
    }

    private static void addOperatorToOperatorStack(IToken token, ETokenType type, Stack<IToken> operatorStack, List<IToken> outputQueue) {
        while (type != ETokenType.EQ && !operatorStack.isEmpty() && ArithmeticExpressionTokenUtils.precedence(operatorStack.peek()) >= ArithmeticExpressionTokenUtils.precedence(token)) {
            outputQueue.add(operatorStack.pop());
        }
        operatorStack.push(token);
    }

    private static void closeParentheses(Stack<IToken> operatorStack, List<IToken> outputQueue) {
        while (operatorStack.peek().getType() != ETokenType.LPAREN) {
            outputQueue.add(operatorStack.pop());
            if (!operatorStack.isEmpty()) continue;
            return;
        }
        operatorStack.pop();
    }

    private static Optional<Integer> evaluateExpression(List<IToken> tokens, Map<String, Integer> statesByVariableName) {
        Stack<Integer> operandStack = new Stack<Integer>();
        for (IToken token : tokens) {
            ETokenType type = token.getType();
            if (!type.isOperator()) {
                operandStack.push(IntegerArithmeticExpressionEvaluator.getIntValue(token));
                continue;
            }
            if (operandStack.isEmpty()) {
                return Optional.empty();
            }
            if (type == ETokenType.EQ) {
                statesByVariableName.put(token.getText(), (Integer)operandStack.peek());
                continue;
            }
            if (type == ETokenType.COMP) {
                operandStack.push(~((Integer)operandStack.pop()).intValue());
                continue;
            }
            if (type == ETokenType.NOT) {
                operandStack.push(ArithmeticExpressionTokenUtils.evaluateIntegerNegation((Integer)operandStack.pop()));
                continue;
            }
            if (operandStack.size() >= 2) {
                Integer a = (Integer)operandStack.pop();
                Integer b = (Integer)operandStack.pop();
                operandStack.push(IntegerArithmeticExpressionEvaluator.evaluate(token, type, a, b, statesByVariableName));
                continue;
            }
            return Optional.empty();
        }
        if (operandStack.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((Integer)operandStack.pop());
    }

    private static List<IToken> resolveVariables(List<IToken> tokens, Map<String, Integer> statesByVariableName, Map<String, Integer> writesResolved) {
        ArrayList<IToken> result = new ArrayList<IToken>();
        for (int i = 0; i < tokens.size(); ++i) {
            IToken token = tokens.get(i);
            ETokenType type = token.getType();
            if (type == ETokenType.IDENTIFIER) {
                String variableName = token.getText();
                if (!statesByVariableName.containsKey(variableName)) {
                    writesResolved.remove(variableName);
                    continue;
                }
                int value = statesByVariableName.get(variableName);
                int indexBefore = IntegerArithmeticExpressionEvaluator.getTokenIndexAroundEnclosingParenthesis(tokens, i, true);
                int indexAfter = IntegerArithmeticExpressionEvaluator.getTokenIndexAroundEnclosingParenthesis(tokens, i, false);
                int currentVariableValue = IntegerArithmeticExpressionEvaluator.evaluateInDecrements(tokens, variableName, value, indexBefore, statesByVariableName, writesResolved);
                result.add(token.newToken(ETokenType.INTEGER_LITERAL, token.getOffset(), token.getLineNumber(), String.valueOf(currentVariableValue), token.getOriginId()));
                IntegerArithmeticExpressionEvaluator.evaluateInDecrements(tokens, variableName, currentVariableValue, indexAfter, statesByVariableName, writesResolved);
                continue;
            }
            if (type == ETokenType.PLUSPLUS || type == ETokenType.MINUSMINUS) continue;
            result.add(token);
        }
        return result;
    }

    private static Integer evaluateInDecrements(List<IToken> tokens, String variableName, int currentVariableValue, int operatorIndex, Map<String, Integer> statesByVariableName, Map<String, Integer> writesResolved) {
        ETokenType type;
        if (operatorIndex != -1 && ((type = tokens.get(operatorIndex).getType()) == ETokenType.PLUSPLUS || type == ETokenType.MINUSMINUS)) {
            currentVariableValue = type == ETokenType.PLUSPLUS ? ++currentVariableValue : --currentVariableValue;
            writesResolved.merge(variableName, 1, Integer::sum);
            statesByVariableName.put(variableName, currentVariableValue);
        }
        return currentVariableValue;
    }

    private static List<IToken> resolveUnaryOperators(List<IToken> tokens) {
        Set<Integer> unaryPlusIndices = ArithmeticExpressionTokenUtils.getUnaryOperatorLocations(tokens, ETokenType.PLUS);
        Set<Integer> unaryMinusIndices = ArithmeticExpressionTokenUtils.getUnaryOperatorLocations(tokens, ETokenType.MINUS);
        ArrayList<IToken> result = new ArrayList<IToken>();
        HashSet<Integer> markClosingParen = new HashSet<Integer>();
        boolean skipToken = false;
        for (int i = 0; i < tokens.size(); ++i) {
            if (skipToken) {
                skipToken = false;
                continue;
            }
            if (markClosingParen.contains(i)) {
                IToken token = tokens.get(i);
                result.add(token.newToken(ETokenType.RPAREN, token.getOffset(), token.getLineNumber(), ")", token.getOriginId()));
            }
            if (unaryMinusIndices.contains(i)) {
                skipToken = IntegerArithmeticExpressionEvaluator.resolveUnaryMinus(tokens, i, result, markClosingParen);
                continue;
            }
            if (unaryPlusIndices.contains(i)) continue;
            result.add(tokens.get(i));
        }
        IToken token = (IToken)result.get(result.size() - 1);
        int i = tokens.size();
        while (markClosingParen.contains(i)) {
            result.add(token.newToken(ETokenType.RPAREN, token.getOffset(), token.getLineNumber(), ")", token.getOriginId()));
            ++i;
        }
        return result;
    }

    private static boolean resolveUnaryMinus(List<IToken> tokens, int index, List<IToken> result, Set<Integer> markClosingParen) {
        IToken prevToken = IntegerArithmeticExpressionEvaluator.getTokenBeforeEnclosingParenthesis(tokens, index);
        int prevOperatorInResult = TokenStreamUtils.lastTokenMatching(result, (ITokenMatcher)ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.PLUS, ETokenType.MINUS}));
        if (prevToken != null && prevOperatorInResult != -1 && (prevToken.getType() == ETokenType.MINUS || prevToken.getType() == ETokenType.PLUS)) {
            IntegerArithmeticExpressionEvaluator.flip(result, result.get(prevOperatorInResult).getType());
        } else {
            IToken token = tokens.get(index + 1);
            if (token.getType() == ETokenType.INTEGER_LITERAL) {
                int negatedValue = Integer.parseInt(token.getText()) * -1;
                return IntegerArithmeticExpressionEvaluator.addToResult(negatedValue, token, result);
            }
            IntegerArithmeticExpressionEvaluator.convertUnaryMinus(token, index, tokens, result, markClosingParen);
        }
        return false;
    }

    private static boolean addToResult(int newValue, IToken originalToken, List<IToken> result) {
        if (originalToken.getType() == ETokenType.INTEGER_LITERAL) {
            result.add(originalToken.newToken(originalToken.getType(), originalToken.getOffset(), originalToken.getLineNumber(), String.valueOf(newValue), originalToken.getOriginId()));
            return true;
        }
        return false;
    }

    private static void convertUnaryMinus(IToken token, int i, List<IToken> tokens, List<IToken> result, Set<Integer> markClosingParen) {
        result.add(token.newToken(ETokenType.LPAREN, token.getOffset(), token.getLineNumber(), "(", token.getOriginId()));
        result.add(token.newToken(ETokenType.INTEGER_LITERAL, token.getOffset(), token.getLineNumber(), "-1", token.getOriginId()));
        result.add(token.newToken(ETokenType.MULT, token.getOffset(), token.getLineNumber(), "*", token.getOriginId()));
        int newEndTokenIndex = TokenStreamUtils.findMatchingClosingToken(tokens, (int)(i + 2), (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        if (newEndTokenIndex == -1) {
            newEndTokenIndex = tokens.size();
            while (markClosingParen.contains(newEndTokenIndex)) {
                ++newEndTokenIndex;
            }
        }
        markClosingParen.add(newEndTokenIndex);
    }

    private static void flip(List<IToken> tokens, ETokenType flipOperator) {
        int operatorIndex = TokenStreamUtils.lastTokenMatching(tokens, (ITokenMatcher)flipOperator);
        IToken flip = tokens.get(operatorIndex);
        tokens.remove(operatorIndex);
        ETokenType flipType = flipOperator == ETokenType.MINUS ? ETokenType.PLUS : ETokenType.MINUS;
        String flipText = flipOperator == ETokenType.MINUS ? "+" : "-";
        tokens.add(operatorIndex, flip.newToken(flipType, flip.getOffset(), flip.getLineNumber(), flipText, flip.getOriginId()));
    }

    private static IToken getTokenBeforeEnclosingParenthesis(List<IToken> tokens, int start) {
        int index = IntegerArithmeticExpressionEvaluator.getTokenIndexAroundEnclosingParenthesis(tokens, start, true);
        if (index == -1) {
            return null;
        }
        return tokens.get(index);
    }

    private static int getTokenIndexAroundEnclosingParenthesis(List<IToken> tokens, int start, boolean before) {
        if (start <= 0 && before || start >= tokens.size() - 1 && !before) {
            return -1;
        }
        int i = 1;
        int j = start + 1;
        if (before && tokens.get(start - i).getType() != ETokenType.LPAREN) {
            return start - i;
        }
        if (!before && tokens.get(j).getType() != ETokenType.RPAREN) {
            return j;
        }
        if (start - i < 0) {
            return -1;
        }
        if (tokens.get(j).getType() == ETokenType.LPAREN) {
            j = TokenStreamUtils.findMatchingClosingToken(tokens, (int)start, (ETokenType)ETokenType.LPAREN, (ETokenType)ETokenType.RPAREN);
        }
        while (tokens.get(start - i).getType() == ETokenType.LPAREN) {
            if (tokens.get(j).getType() != ETokenType.RPAREN || j >= tokens.size()) {
                return -1;
            }
            ++j;
            if (start - ++i >= 0) continue;
            return -1;
        }
        if (before) {
            return start - i;
        }
        return j;
    }

    private static int getIntValue(IToken token) {
        String tokenText = token.getText();
        return AdvancedIntVariableWriteHeuristic.getIntegerFromString(tokenText);
    }

    private static Integer evaluate(IToken token, ETokenType operator, int a, int b, Map<String, Integer> statesByVariableName) {
        int result = ArithmeticExpressionTokenUtils.evaluate(operator, a, b);
        if (token instanceof AssignmentTokenMarker) {
            statesByVariableName.put(((AssignmentTokenMarker)token).getVariable(), result);
        }
        return result;
    }
}

