/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow;

import com.teamscale.index.dataflow.DataflowAnalysisBase;
import com.teamscale.index.dataflow.DataflowAnalysisResult;
import com.teamscale.index.dataflow.EDirection;
import com.teamscale.index.dataflow.ILattice;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableMap;

public abstract class PathInsensitiveDataflowAnalysisBase<KeyT, ValueT>
extends DataflowAnalysisBase<Map<KeyT, ValueT>, UnmodifiableMap<KeyT, ValueT>, DataflowAnalysisResult<KeyT, ValueT>> {
    @Override
    protected boolean addToOutState(UnmodifiableMap<KeyT, ValueT> transformationResult, Map<KeyT, ValueT> outputState, ControlFlowNode node) {
        UnmodifiableMap<KeyT, ValueT> mergedState = this.join(Arrays.asList(transformationResult, outputState), node);
        if (mergedState.equals(outputState)) {
            return false;
        }
        outputState.clear();
        outputState.putAll((Map<KeyT, ValueT>)mergedState);
        return true;
    }

    @Override
    protected boolean isFeasible(UnmodifiableMap<KeyT, ValueT> transformationResult) {
        return true;
    }

    @Override
    protected UnmodifiableMap<KeyT, ValueT> getStartingInput(ControlFlowGraph cfg) {
        return CollectionUtils.asUnmodifiable((Map)((Map)this.getDefaultState(this.getStartNode())));
    }

    @Override
    protected DataflowAnalysisResult<KeyT, ValueT> getResult(ControlFlowGraph cfg, Map<ControlFlowNode, Map<KeyT, ValueT>> outStates) {
        if (this.getDirection() == EDirection.BACKWARD) {
            return new DataflowAnalysisResult(cfg, this.computeInStates());
        }
        return new DataflowAnalysisResult<KeyT, ValueT>(cfg, outStates);
    }

    @Override
    protected UnmodifiableMap<KeyT, ValueT> join(List<Map<KeyT, ValueT>> states, ControlFlowNode node) {
        HashMap<KeyT, ValueT> outState = new HashMap<KeyT, ValueT>();
        for (Map<KeyT, ValueT> inState : states) {
            for (Map.Entry<KeyT, ValueT> entry : inState.entrySet()) {
                KeyT variable = entry.getKey();
                Object oldValue = outState.get(variable);
                if (oldValue == null) {
                    oldValue = this.getLattice().getBottom();
                }
                ValueT newValue = this.getLattice().leastUpperBound(oldValue, entry.getValue());
                outState.put(variable, newValue);
            }
        }
        return CollectionUtils.asUnmodifiable(outState);
    }

    protected abstract ILattice<ValueT> getLattice();
}

