/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.division_by_zero;

import com.teamscale.index.dataflow.DataflowAnalysisResult;
import com.teamscale.index.dataflow.DataflowFindingsCreatorBase;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.division_by_zero.DivisionByZeroLattice;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.collections.UnmodifiableMap;
import org.conqat.lib.commons.string.LineOffsetConverter;

public class DivisionByZeroAnalysisFindingsCreator
extends DataflowFindingsCreatorBase<DataflowAnalysisResult<String, DivisionByZeroLattice.DivByZeroAnalysisState>> {
    public static final String FINDINGS_GROUP = "Possible division by zero";
    public static final String DIV_BY_ZERO_MESSAGE = "Possible division by zero";
    public static final String MOD_BY_ZERO_MESSAGE = "Possible modulo by zero";

    protected DivisionByZeroAnalysisFindingsCreator(List<IFalsePositiveFilter> filters) {
        super(filters, "Possible division by zero");
    }

    @Override
    protected void createFindingsInGroup(TokenElementInfo element, DataflowAnalysisResult<String, DivisionByZeroLattice.DivByZeroAnalysisState> result, List<ShallowEntity> fileEntities, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) throws ConQATException {
        ControlFlowGraph controlFlowGraph = result.getControlFlowGraph();
        TwoDimHashMap<ControlFlowNode, String, DivisionByZeroLattice.DivByZeroAnalysisState> data = result.getFacts();
        for (ControlFlowNode node : controlFlowGraph.listDepthFirst()) {
            UnmodifiableMap variableStates = data.getSecondMap((Object)node);
            Set<String> readVariables = node.getReadWriteInfo().getReads();
            for (String variable : readVariables) {
                DivisionByZeroLattice.DivByZeroAnalysisState variableState = (DivisionByZeroLattice.DivByZeroAnalysisState)variableStates.get(variable);
                if (variableState == null || variableState.getState() != DivisionByZeroLattice.EVariableState.DIV_BY_ZERO && variableState.getState() != DivisionByZeroLattice.EVariableState.MOD_BY_ZERO) continue;
                TextRegionLocation variableLocation = DivisionByZeroAnalysisFindingsCreator.getFindingLocation(variable, element, node, offsetTransformer, rawLineOffsetConverter);
                this.createFinding(element, controlFlowGraph, node, variable, fileEntities, variableLocation, (Map<?, ?>)variableStates);
            }
        }
    }

    @Override
    protected String getMessage(String name, ControlFlowNode node, ELanguage language, Map<?, ?> states) {
        DivisionByZeroLattice.EVariableState variableState = ((DivisionByZeroLattice.DivByZeroAnalysisState)states.get(name)).getState();
        if ((name = name.replace(" ", "")).charAt(name.length() - 1) == ';') {
            name = name.substring(0, name.length() - 1);
        }
        if (variableState == DivisionByZeroLattice.EVariableState.DIV_BY_ZERO) {
            return "Possible division by zero" + DivisionByZeroAnalysisFindingsCreator.wrapZeroVariableInMessage(name);
        }
        return MOD_BY_ZERO_MESSAGE + DivisionByZeroAnalysisFindingsCreator.wrapZeroVariableInMessage(name);
    }

    private static String wrapZeroVariableInMessage(String variableName) {
        return " (" + variableName + " is zero)";
    }
}

