/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.filters.java;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.controlflowgraph.heuristics.java.JavaDataFlowHeuristic;
import com.teamscale.index.dataflow.filters.FalsePositiveFilterUtils;
import com.teamscale.index.dataflow.filters.IFalsePositiveFilter;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.filter.JavaSuppressWarningsUnusuedEntityFilter;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.EnumSet;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class JavaSuppressWarningsUnusedFilter
implements IFalsePositiveFilter {
    private static final EnumSet<ETokenType> TYPES = EnumSet.of(ETokenType.IDENTIFIER, new ETokenType[]{ETokenType.BOOLEAN, ETokenType.BYTE, ETokenType.CHAR, ETokenType.DOUBLE, ETokenType.FLOAT, ETokenType.INT, ETokenType.LONG, ETokenType.SHORT});
    private static final TokenPattern ANNOTATED_PARAMETER_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.AT_OPERATOR}).repeated(new Object[]{ETokenType.IDENTIFIER, ETokenType.DOT}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0).sequence(new Object[]{ETokenType.LPAREN}).sequence(new Object[]{ETokenType.STRING_LITERAL}).group(1).sequence(new Object[]{ETokenType.RPAREN}).sequence(new Object[]{TYPES}).repeated(new Object[]{ETokenType.DOT, ETokenType.IDENTIFIER}).skipNested((Object)ETokenType.LT, (Object)ETokenType.GT, true).repeated(new Object[]{ETokenType.LBRACK, ETokenType.RBRACK}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(2);

    @Override
    public boolean isFiltered(String variable, ControlFlowNode statement, ControlFlowGraph cfg, List<ShallowEntity> fileEntities, TokenElementInfo node) {
        return JavaSuppressWarningsUnusedFilter.isSuppressedMethod(cfg.getEntities()) || JavaSuppressWarningsUnusedFilter.isSuppressedParameter(cfg, variable);
    }

    private static boolean isSuppressedParameter(ControlFlowGraph cfg, String variable) {
        if (!FalsePositiveFilterUtils.isMethodParameter(variable, cfg)) {
            return false;
        }
        ControlFlowNode parameterControlFlowNode = cfg.getRoot();
        List<IToken> parameterTokens = parameterControlFlowNode.getTokens();
        List matches = ANNOTATED_PARAMETER_PATTERN.findAll(parameterTokens);
        for (TokenPatternMatch match : matches) {
            if (!match.groupString(2).equals(variable)) continue;
            return JavaSuppressWarningsUnusuedEntityFilter.SUPPRESS_WARNINGS_ANNOTATIONS.contains(match.groupString(0)) && match.groupString(1).equals("\"unused\"");
        }
        return false;
    }

    private static boolean isSuppressedMethod(List<ShallowEntity> executableEntities) {
        for (ShallowEntity entity : executableEntities) {
            if (!JavaDataFlowHeuristic.SUPPRESS_WARNINGS_ANNOTATION_MATCHER.matches(entity)) continue;
            UnmodifiableList tokens = entity.ownStartTokens();
            List indices = TokenStreamUtils.findAll((List)tokens, (ITokenMatcher)ETokenType.STRING_LITERAL);
            for (Integer index : indices) {
                if (!((IToken)tokens.get(index)).getText().equals("\"unused\"")) continue;
                return true;
            }
        }
        return false;
    }
}

