/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.analysislocal;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.MethodTaintGraphGenerationAnalysisState;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.TaintSinkRecognizer;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.ETaintSinkType;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphSink;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.abap.AbapMethodCallRecognizer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.LineOffsetConverter;

public class AbapTaintSinkRecognizer {
    private static final String GENERIC_FUNCTION_CALL_SINK_DESCRIPTION_TEMPLATE = "Generic code invocation `%variableName%`";
    private static final String DYNAMIC_CLASS_CREATION_SINK_DESCRIPTION_TEMPLATE = "Dynamic creation of instance of class `%variableName%`";
    private static final String GENERIC_SUBROUTINE_SINK_DESCRIPTION_TEMPLATE = "`PERFORM` call of generic subroutine `%variableName%`";
    private static final String GENERIC_PROGRAM_SINK_DESCRIPTION_TEMPLATE = "`PERFORM` call of subroutine in generic program `%variableName%`";
    private static final String OPEN_DATASET_SINK_DESCRIPTION_TEMPLATE = "Tainted variable `%variableName%` determines which dataset is loaded.";
    private static final String DELETE_DATASET_SINK_DESCRIPTION_TEMPLATE = "Tainted variable `%variableName%` determines which dataset is deleted.";
    private static final String OPEN_DATASET_FILTER_SINK_DESCRIPTION_TEMPLATE = "`OPEN DATASET FILTER` using tainted variable `%variableName%`";
    private static final String SYSTEM_COMMAND_INJECTION_SINK_DESCRIPTION_TEMPLATE = "Call target determined by tainted variable `%variableName%`";
    private static final String OS_COMMAND_INJECTION_SINK_DESCRIPTION_TEMPLATE = "OS command injection with tainted variable `%variableName%`";
    private static final String COMMAND_INJECTION_SINK_DESCRIPTION_TEMPLATE = "ABAP Command Injection with tainted variable `%variableName%`";
    private static final String NATIVE_SQL_INJECTION_SINK_DESCRIPTION_TEMPLATE = "Native SQL injection with tainted variable `%variableName%`";
    private static final String LOOP_BOUND_SINK_DESCRIPTION_TEMPLATE = "Loop bound influenced by tainted variable `%variableName%`";
    private static final String GENERIC_MODULE_EXECUTION_SUBMIT_SINK_DESCRIPTION_TEMPLATE = "Submitted method determined by tainted variable `%variableName%`";
    private static final String GENERIC_MODULE_EXECUTION_CALL_SINK_DESCRIPTION_TEMPLATE = "Name of called entity is influenced by tainted variable `%variableName%`";
    private static final String OTHER_SINK_DESCRIPTION_TEMPLATE = "Security-critical statement is influenced by tainted variable `%variableName%`";
    private static final String OPENSQL_INJECTION_SINK_DESCRIPTION_TEMPLATE = "`%variableName%` may be tainted in dynamic OpenSQL statement.";
    private static final String USER_DEPENDENT_DB_ACCESS_SINK_DESCRIPTION_TEMPLATE = "`%variableName%` may be tainted in OpenSQL statement.";
    private static final String CL_GUI_FRONTEND_SERVICES_CLASSNAME = "cl_gui_frontend_services";
    private static final Map<String, Set<String>> CL_GUI_FRONTEND_SERVICES_FUNCTIONS = Map.ofEntries(Map.entry("directory_create", Collections.singleton("directory")), Map.entry("directory_delete", Collections.singleton("directory")), Map.entry("directory_list_files", Collections.singleton("directory")), Map.entry("directory_set_current", Collections.singleton("current_directory")), Map.entry("file_copy", CollectionUtils.asHashSet((Object[])new String[]{"source", "destination"})), Map.entry("file_delete", Collections.singleton("filename")), Map.entry("file_get_attributes", Collections.singleton("filename")), Map.entry("file_set_attributes", Collections.singleton("filename")), Map.entry("gui_download", Collections.singleton("filename")), Map.entry("gui_upload", Collections.singleton("filename")));
    private static final Map<String, String> DIRECTORY_TRAVERSAL_FUNCTIONS = Map.ofEntries(Map.entry("'gui_upload'", "filename"), Map.entry("'gui_remove_directory'", "dirname"), Map.entry("'gui_delete_file'", "file_name"), Map.entry("'gui_download'", "filename"), Map.entry("'gui_get_file_info'", "fname"), Map.entry("'gui_create_directory'", "dirname"));
    private static final Map<String, Set<String>> SXPG_FUNCTION_SINKS = Map.ofEntries(Map.entry("'SXPG_COMMAND_EXECUTE'", CollectionUtils.asHashSet((Object[])new String[]{"additional_parameters"})), Map.entry("'SXPG_COMMAND_EXECUTE_LONG'", CollectionUtils.asHashSet((Object[])new String[]{"additional_parameters", "long_params"})), Map.entry("'SXPG_CALL_SYSTEM'", CollectionUtils.asHashSet((Object[])new String[]{"additional_parameters", "long_params"})));

    PairList<TaintGraphReferenceBase, TaintGraphSink> getAbapSinkRelations(ControlFlowNode node, MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        PairList sinkRelations = new PairList();
        List<IToken> tokens = node.getTokens();
        if (tokens.size() <= 2) {
            return PairList.emptyPairList();
        }
        AbapTaintSinkRecognizer.checkForOpenDatasetFilterSink(state, element, (PairList<TaintGraphReferenceBase, TaintGraphSink>)sinkRelations, tokens, offsetTransformer, rawLineOffsetConverter);
        AbapTaintSinkRecognizer.checkForCallSystemFunctions(node, state, element, (PairList<TaintGraphReferenceBase, TaintGraphSink>)sinkRelations, tokens, offsetTransformer, rawLineOffsetConverter);
        AbapTaintSinkRecognizer.checkForReadInsertReportSink(state, element, (PairList<TaintGraphReferenceBase, TaintGraphSink>)sinkRelations, tokens, offsetTransformer, rawLineOffsetConverter);
        AbapTaintSinkRecognizer.checkForGenerateSubroutineSink(state, element, (PairList<TaintGraphReferenceBase, TaintGraphSink>)sinkRelations, tokens, offsetTransformer, rawLineOffsetConverter);
        AbapTaintSinkRecognizer.checkForExecSQLSink(state, element, (PairList<TaintGraphReferenceBase, TaintGraphSink>)sinkRelations, tokens, offsetTransformer, rawLineOffsetConverter);
        AbapTaintSinkRecognizer.checkForLoopIterationLimitSink(node, state, element, (PairList<TaintGraphReferenceBase, TaintGraphSink>)sinkRelations, tokens, offsetTransformer, rawLineOffsetConverter);
        AbapTaintSinkRecognizer.checkForOpenDatasetSink(state, element, (PairList<TaintGraphReferenceBase, TaintGraphSink>)sinkRelations, tokens, offsetTransformer, rawLineOffsetConverter);
        AbapTaintSinkRecognizer.checkForGenericModuleExecutionSink(state, element, (PairList<TaintGraphReferenceBase, TaintGraphSink>)sinkRelations, tokens, offsetTransformer, rawLineOffsetConverter);
        AbapTaintSinkRecognizer.checkForOpenSqlInjectionSinks(node, state, element, (PairList<TaintGraphReferenceBase, TaintGraphSink>)sinkRelations, tokens, offsetTransformer, rawLineOffsetConverter);
        AbapTaintSinkRecognizer.checkForOpenSqlInjectionSinkInWithStatement(node, state, element, (PairList<TaintGraphReferenceBase, TaintGraphSink>)sinkRelations, tokens, offsetTransformer, rawLineOffsetConverter);
        AbapTaintSinkRecognizer.checkForSystemCommandInjection(state, element, (PairList<TaintGraphReferenceBase, TaintGraphSink>)sinkRelations, tokens, offsetTransformer, rawLineOffsetConverter);
        AbapTaintSinkRecognizer.checkForCreateObjectSink(state, element, (PairList<TaintGraphReferenceBase, TaintGraphSink>)sinkRelations, tokens, offsetTransformer, rawLineOffsetConverter);
        AbapTaintSinkRecognizer.checkForPerformCallToGenericCode(state, element, (PairList<TaintGraphReferenceBase, TaintGraphSink>)sinkRelations, tokens, offsetTransformer, rawLineOffsetConverter);
        AbapTaintSinkRecognizer.checkForDirectoryTraversalSink(state, element, (PairList<TaintGraphReferenceBase, TaintGraphSink>)sinkRelations, tokens, offsetTransformer, rawLineOffsetConverter);
        AbapTaintSinkRecognizer.checkForGuiFrontendServices(state, element, (PairList<TaintGraphReferenceBase, TaintGraphSink>)sinkRelations, tokens, offsetTransformer, rawLineOffsetConverter);
        AbapTaintSinkRecognizer.checkForOpenCursorSink(state, element, (PairList<TaintGraphReferenceBase, TaintGraphSink>)sinkRelations, tokens, offsetTransformer, rawLineOffsetConverter);
        AbapTaintSinkRecognizer.checkForSxpgCommands(state, element, (PairList<TaintGraphReferenceBase, TaintGraphSink>)sinkRelations, tokens, offsetTransformer, rawLineOffsetConverter);
        return sinkRelations;
    }

    private static void checkForOpenSqlInjectionSinks(ControlFlowNode node, MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, PairList<TaintGraphReferenceBase, TaintGraphSink> sinkRelations, List<IToken> tokens, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        if (tokens.size() >= 2 && EnumSet.of(ETokenType.SELECT, ETokenType.DELETE, ETokenType.UPDATE, ETokenType.INSERT, ETokenType.MODIFY).contains(tokens.get(0).getType()) && tokens.get(1).getType() != ETokenType.REPORT) {
            for (String read : node.getReadWriteInfo().getReads()) {
                if (AbapTaintSinkRecognizer.isEnclosedByParentheses(read, tokens)) {
                    sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(read, OPENSQL_INJECTION_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.SQL_INJECTION, element, offsetTransformer, rawLineOffsetConverter));
                    continue;
                }
                sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(read, USER_DEPENDENT_DB_ACCESS_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.USER_DEPENDENT_DB_ACCESS, element, offsetTransformer, rawLineOffsetConverter));
            }
        }
    }

    private static void checkForOpenSqlInjectionSinkInWithStatement(ControlFlowNode node, MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, PairList<TaintGraphReferenceBase, TaintGraphSink> sinkRelations, List<IToken> tokens, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        if (tokens.size() <= 4) {
            return;
        }
        int startOfSequence = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.AS, ETokenType.LPAREN});
        if (startOfSequence != -1) {
            AbapTaintSinkRecognizer.checkForOpenSqlInjectionSinks(node, state, element, sinkRelations, tokens.subList(startOfSequence + 2, tokens.size()), offsetTransformer, rawLineOffsetConverter);
        }
    }

    private static boolean isEnclosedByParentheses(String variableName, List<IToken> tokens) {
        for (Integer lParenIndex : TokenStreamUtils.firstTokenOfTypeSequences(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN})) {
            if (!tokens.get(lParenIndex + 1).getText().equals(variableName)) continue;
            return true;
        }
        return false;
    }

    private static void checkForGenericModuleExecutionSink(MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, PairList<TaintGraphReferenceBase, TaintGraphSink> sinkRelations, List<IToken> tokens, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        if (tokens.size() >= 2 && TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.SUBMIT})) {
            sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(tokens.get(1).getText().toLowerCase(), GENERIC_MODULE_EXECUTION_SUBMIT_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.GENERIC_MODULE_EXECUTION, element, offsetTransformer, rawLineOffsetConverter));
        }
        if (tokens.size() < 3) {
            return;
        }
        if (TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.CALL})) {
            ETokenType calledEntityType = tokens.get(1).getType();
            if (EnumSet.of(ETokenType.TRANSACTION, ETokenType.FUNCTION, ETokenType.METHOD).contains(calledEntityType)) {
                if (!EnumSet.of(ETokenType.EQGT, ETokenType.ARROW).contains(tokens.get(3).getType()) && LanguageFeatureParser.ABAP.isPossiblyIdentifier(tokens.get(2))) {
                    sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(tokens.get(2).getText().toLowerCase(), GENERIC_FUNCTION_CALL_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.GENERIC_MODULE_EXECUTION, element, offsetTransformer, rawLineOffsetConverter));
                }
                AbapTaintSinkRecognizer.checkForDynamicGenericModuleExecution(state, element, sinkRelations, tokens, offsetTransformer, rawLineOffsetConverter);
            }
        }
    }

    private static void checkForCreateObjectSink(MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, PairList<TaintGraphReferenceBase, TaintGraphSink> sinkRelations, List<IToken> tokens, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        if (tokens.size() < 6) {
            return;
        }
        if (TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.CREATE, ETokenType.OBJECT}) && LanguageFeatureParser.ABAP.isPossiblyIdentifier(tokens.get(2)) && TokenStreamUtils.hasTokenTypeSequence(tokens, (int)3, (ETokenType[])new ETokenType[]{ETokenType.TYPE, ETokenType.LPAREN}) && LanguageFeatureParser.ABAP.isPossiblyIdentifier(tokens.get(5)) && tokens.get(6).getType() == ETokenType.RPAREN) {
            sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(tokens.get(5).getText().toLowerCase(), DYNAMIC_CLASS_CREATION_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.GENERIC_MODULE_EXECUTION, element, offsetTransformer, rawLineOffsetConverter));
        }
    }

    private static void checkForPerformCallToGenericCode(MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, PairList<TaintGraphReferenceBase, TaintGraphSink> sinkRelations, List<IToken> tokens, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        int startOfInProgram;
        if (tokens.size() <= 1 && tokens.get(0).getType() == ETokenType.PERFORM) {
            return;
        }
        if (tokens.size() >= 4 && TokenStreamUtils.hasTokenTypeSequence(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.PERFORM, ETokenType.LPAREN}) && LanguageFeatureParser.ABAP.isPossiblyIdentifier(tokens.get(2)) && tokens.get(3).getType() == ETokenType.RPAREN) {
            sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(tokens.get(2).getText().toLowerCase(), GENERIC_SUBROUTINE_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.GENERIC_MODULE_EXECUTION, element, offsetTransformer, rawLineOffsetConverter));
        }
        if ((startOfInProgram = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)1, (ETokenType[])new ETokenType[]{ETokenType.IN, ETokenType.PROGRAM, ETokenType.LPAREN})) != -1 && tokens.size() > startOfInProgram + 4 && LanguageFeatureParser.ABAP.isPossiblyIdentifier(tokens.get(startOfInProgram + 3)) && tokens.get(startOfInProgram + 4).getType() == ETokenType.RPAREN) {
            sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(tokens.get(startOfInProgram + 3).getText().toLowerCase(), GENERIC_PROGRAM_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.GENERIC_MODULE_EXECUTION, element, offsetTransformer, rawLineOffsetConverter));
        }
    }

    private static void checkForDynamicGenericModuleExecution(MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, PairList<TaintGraphReferenceBase, TaintGraphSink> sinkRelations, List<IToken> tokens, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        int lparenAfterArrow;
        int patternStart = 2;
        if (TokenStreamUtils.startsWith(tokens.subList(2, tokens.size() - 1), (ETokenType[])new ETokenType[]{ETokenType.LPAREN, ETokenType.IDENTIFIER, ETokenType.RPAREN})) {
            sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(tokens.get(3).getText().toLowerCase(), GENERIC_MODULE_EXECUTION_CALL_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.GENERIC_MODULE_EXECUTION, element, offsetTransformer, rawLineOffsetConverter));
            patternStart += 3;
        } else {
            ++patternStart;
        }
        if (tokens.size() <= patternStart) {
            return;
        }
        int rparenBeforeArrow = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)patternStart, (ETokenType[])new ETokenType[]{ETokenType.RPAREN, ETokenType.ARROW});
        if (rparenBeforeArrow == -1) {
            rparenBeforeArrow = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)patternStart, (ETokenType[])new ETokenType[]{ETokenType.RPAREN, ETokenType.EQGT});
        }
        if (rparenBeforeArrow != -1 && tokens.get(rparenBeforeArrow - 2).getType() == ETokenType.LPAREN) {
            sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariableAt(rparenBeforeArrow - 1, tokens, ETaintSinkType.GENERIC_MODULE_EXECUTION, GENERIC_MODULE_EXECUTION_CALL_SINK_DESCRIPTION_TEMPLATE, element, state, offsetTransformer, rawLineOffsetConverter));
        }
        if ((lparenAfterArrow = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)patternStart, (ETokenType[])new ETokenType[]{ETokenType.ARROW, ETokenType.LPAREN})) == -1) {
            lparenAfterArrow = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)patternStart, (ETokenType[])new ETokenType[]{ETokenType.EQGT, ETokenType.LPAREN});
        }
        if (lparenAfterArrow != -1 && tokens.get(lparenAfterArrow + 3).getType() == ETokenType.RPAREN) {
            sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariableAt(lparenAfterArrow + 2, tokens, ETaintSinkType.GENERIC_MODULE_EXECUTION, GENERIC_MODULE_EXECUTION_CALL_SINK_DESCRIPTION_TEMPLATE, element, state, offsetTransformer, rawLineOffsetConverter));
        }
    }

    private static void checkForLoopIterationLimitSink(ControlFlowNode node, MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, PairList<TaintGraphReferenceBase, TaintGraphSink> sinkRelations, List<IToken> tokens, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        int index = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)0, (int)tokens.size(), (ETokenType[])new ETokenType[]{ETokenType.DO, ETokenType.IDENTIFIER, ETokenType.TIMES, ETokenType.DOT});
        if (index >= 0) {
            sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(tokens.get(index + 1).getText().toLowerCase(), LOOP_BOUND_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.OTHER, element, offsetTransformer, rawLineOffsetConverter));
        }
        if (TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.WHILE})) {
            sinkRelations.addAll(TaintSinkRecognizer.getSinksForAllReadKnownVariables(node, LOOP_BOUND_SINK_DESCRIPTION_TEMPLATE, state, element, tokens, ETaintSinkType.OTHER, offsetTransformer, rawLineOffsetConverter));
        }
    }

    private static void checkForExecSQLSink(MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, PairList<TaintGraphReferenceBase, TaintGraphSink> sinkRelations, List<IToken> tokens, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        int index = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)0, (int)tokens.size(), (ETokenType[])new ETokenType[]{ETokenType.EXEC, ETokenType.SQL});
        if (index >= 0 && index + 2 < tokens.size()) {
            sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(tokens.get(index + 2).getText().toLowerCase(), NATIVE_SQL_INJECTION_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.SQL_INJECTION, element, offsetTransformer, rawLineOffsetConverter));
        }
    }

    private static void checkForGenerateSubroutineSink(MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, PairList<TaintGraphReferenceBase, TaintGraphSink> sinkRelations, List<IToken> tokens, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        int index = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)0, (int)tokens.size(), (ETokenType[])new ETokenType[]{ETokenType.GENERATE, ETokenType.SUBROUTINE, ETokenType.POOL});
        if (index >= 0 && index + 3 < tokens.size()) {
            sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(tokens.get(index + 3).getText().toLowerCase(), COMMAND_INJECTION_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.ABAP_COMMAND_INJECTION, element, offsetTransformer, rawLineOffsetConverter));
        }
    }

    private static void checkForReadInsertReportSink(MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, PairList<TaintGraphReferenceBase, TaintGraphSink> sinkRelations, List<IToken> tokens, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        if (tokens.size() < 3) {
            return;
        }
        if (EnumSet.of(ETokenType.READ, ETokenType.INSERT).contains(tokens.get(0).getType()) && tokens.get(1).getType() == ETokenType.REPORT) {
            sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(tokens.get(2).getText().toLowerCase(), COMMAND_INJECTION_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.ABAP_COMMAND_INJECTION, element, offsetTransformer, rawLineOffsetConverter));
            if (tokens.size() >= 5 && tokens.get(3).getType() == ETokenType.FROM) {
                sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(tokens.get(4).getText().toLowerCase(), COMMAND_INJECTION_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.ABAP_COMMAND_INJECTION, element, offsetTransformer, rawLineOffsetConverter));
            }
        }
    }

    private static void checkForCallSystemFunctions(ControlFlowNode node, MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, PairList<TaintGraphReferenceBase, TaintGraphSink> sinkRelations, List<IToken> tokens, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        String literalText;
        if (TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.CALL, ETokenType.CHARACTER_LITERAL}) && ((literalText = tokens.get(1).getText()).equalsIgnoreCase("'SYSTEM'") || literalText.equalsIgnoreCase("'ThWpInfo'"))) {
            sinkRelations.addAll(TaintSinkRecognizer.getSinksForAllReadKnownVariables(node, OS_COMMAND_INJECTION_SINK_DESCRIPTION_TEMPLATE, state, element, tokens, ETaintSinkType.OS_COMMAND, offsetTransformer, rawLineOffsetConverter));
        }
        if (TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.CALL, ETokenType.FUNCTION, ETokenType.CHARACTER_LITERAL})) {
            literalText = tokens.get(2).getText();
            if (literalText.equalsIgnoreCase("'RFC_REMOTE_EXEC'") || literalText.equalsIgnoreCase("'RFC_REMOTE_PIPE'")) {
                sinkRelations.addAll(TaintSinkRecognizer.getSinksForAllReadKnownVariables(node, OS_COMMAND_INJECTION_SINK_DESCRIPTION_TEMPLATE, state, element, tokens, ETaintSinkType.OS_COMMAND, offsetTransformer, rawLineOffsetConverter));
            } else if (literalText.equalsIgnoreCase("'FTP_CONNECT'")) {
                sinkRelations.addAll(TaintSinkRecognizer.getSinksForAllReadKnownVariables(node, OTHER_SINK_DESCRIPTION_TEMPLATE, state, element, tokens, ETaintSinkType.OTHER, offsetTransformer, rawLineOffsetConverter));
            }
        }
    }

    private static void checkForSxpgCommands(MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, PairList<TaintGraphReferenceBase, TaintGraphSink> sinkRelations, List<IToken> tokens, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        if (TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.CALL, ETokenType.FUNCTION, ETokenType.CHARACTER_LITERAL})) {
            String literalText = tokens.get(2).getText();
            for (String sinkParameter : SXPG_FUNCTION_SINKS.getOrDefault(literalText.toUpperCase(), Collections.emptySet())) {
                Optional<String> parameterValue = AbapTaintSinkRecognizer.findNamedParameterValue(tokens, sinkParameter);
                if (!parameterValue.isPresent()) continue;
                sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(parameterValue.get(), OS_COMMAND_INJECTION_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.OS_COMMAND, element, offsetTransformer, rawLineOffsetConverter));
            }
        }
    }

    private static Optional<String> findNamedParameterValue(List<IToken> tokens, String parameterName) {
        int parameterIndex = TokenStreamTextUtils.findFirst(tokens, (int)0, (int)tokens.size(), (String)parameterName);
        if (TokenStreamUtils.hasTokenTypeSequence(tokens, (int)parameterIndex, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.EQ, ETokenType.IDENTIFIER})) {
            return Optional.of(LanguageFeatureParser.ABAP.normalizeVariable(tokens.get(parameterIndex + 2).getText()));
        }
        return Optional.empty();
    }

    private static void checkForSystemCommandInjection(MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, PairList<TaintGraphReferenceBase, TaintGraphSink> sinkRelations, List<IToken> tokens, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        if (TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.CALL}) && tokens.size() > 1) {
            String literalText = tokens.get(1).getText();
            sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(literalText.toLowerCase(), SYSTEM_COMMAND_INJECTION_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.OS_COMMAND, element, offsetTransformer, rawLineOffsetConverter));
        }
    }

    private static void checkForOpenDatasetFilterSink(MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, PairList<TaintGraphReferenceBase, TaintGraphSink> sinkRelations, List<IToken> tokens, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        int filterIdentifierIndex;
        int openDataSetIndex = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.OPEN, ETokenType.DATASET});
        if (openDataSetIndex != -1 && (filterIdentifierIndex = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)openDataSetIndex, (ETokenType[])new ETokenType[]{ETokenType.FILTER})) != -1 && tokens.size() > filterIdentifierIndex) {
            IToken identifierToken = tokens.get(filterIdentifierIndex + 1);
            sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(identifierToken.getText().toLowerCase().toLowerCase(), OPEN_DATASET_FILTER_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.OS_COMMAND, element, offsetTransformer, rawLineOffsetConverter));
        }
    }

    private static void checkForOpenDatasetSink(MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, PairList<TaintGraphReferenceBase, TaintGraphSink> sinkRelations, List<IToken> tokens, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        int deleteDataSetIndex;
        int openDataSetIndex = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.OPEN, ETokenType.DATASET});
        if (openDataSetIndex != -1) {
            IToken identifierToken = tokens.get(openDataSetIndex + 2);
            sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(identifierToken.getText().toLowerCase(), OPEN_DATASET_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.FILENAME, element, offsetTransformer, rawLineOffsetConverter));
        }
        if ((deleteDataSetIndex = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.DELETE, ETokenType.DATASET})) != -1) {
            IToken identifierToken = tokens.get(deleteDataSetIndex + 2);
            sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(identifierToken.getText().toLowerCase(), DELETE_DATASET_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.FILENAME, element, offsetTransformer, rawLineOffsetConverter));
        }
    }

    private static void checkForDirectoryTraversalSink(MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, PairList<TaintGraphReferenceBase, TaintGraphSink> sinkRelations, List<IToken> tokens, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        String formalParameterName;
        Set<IToken> actuals;
        IToken functionNameToken;
        if (TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.CALL, ETokenType.FUNCTION}) && (functionNameToken = tokens.get(2)).getType() == ETokenType.CHARACTER_LITERAL && DIRECTORY_TRAVERSAL_FUNCTIONS.containsKey(functionNameToken.getText().toLowerCase()) && !(actuals = AbapTaintSinkRecognizer.getActualsForExportingParameters(Collections.singleton(formalParameterName = DIRECTORY_TRAVERSAL_FUNCTIONS.get(functionNameToken.getText().toLowerCase())), tokens)).isEmpty()) {
            sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(((IToken)actuals.stream().findAny().get()).getText().toLowerCase(), OPEN_DATASET_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.FILENAME, element, offsetTransformer, rawLineOffsetConverter));
        }
    }

    private static void checkForGuiFrontendServices(MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, PairList<TaintGraphReferenceBase, TaintGraphSink> sinkRelations, List<IToken> tokens, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        IToken functionNameToken;
        if (TokenStreamTextUtils.hasSequence(tokens, (int)0, (String[])new String[]{CL_GUI_FRONTEND_SERVICES_CLASSNAME, "=>"}) && CL_GUI_FRONTEND_SERVICES_FUNCTIONS.containsKey((functionNameToken = tokens.get(2)).getText().toLowerCase())) {
            Set<IToken> actuals = AbapTaintSinkRecognizer.getActualsForExportingParameters(CL_GUI_FRONTEND_SERVICES_FUNCTIONS.get(functionNameToken.getText().toLowerCase()), tokens);
            for (IToken actual : actuals) {
                sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(actual.getText().toLowerCase(), OPEN_DATASET_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.FILENAME, element, offsetTransformer, rawLineOffsetConverter));
            }
        }
    }

    private static void checkForOpenCursorSink(MethodTaintGraphGenerationAnalysisState state, TokenElementInfo element, PairList<TaintGraphReferenceBase, TaintGraphSink> sinkRelations, List<IToken> tokens, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        int fromIndex;
        if (TokenStreamUtils.startsWith(tokens, (ETokenType[])new ETokenType[]{ETokenType.OPEN, ETokenType.CURSOR}) && (fromIndex = TokenStreamUtils.firstTokenOfTypeSequence(tokens, (int)3, (ETokenType[])new ETokenType[]{ETokenType.FROM, ETokenType.LPAREN})) != -1 && tokens.size() > fromIndex + 3 && tokens.get(fromIndex + 3).getType() == ETokenType.RPAREN) {
            sinkRelations.addIfPresent(TaintSinkRecognizer.getSinkIfKnownVariable(tokens.get(fromIndex + 2).getText().toLowerCase(), OPEN_DATASET_SINK_DESCRIPTION_TEMPLATE, state, tokens, ETaintSinkType.SQL_INJECTION, element, offsetTransformer, rawLineOffsetConverter));
        }
    }

    private static Set<IToken> getActualsForExportingParameters(Set<String> formalParameterNames, List<IToken> tokens) {
        Optional callInfo = AbapMethodCallRecognizer.parse(tokens);
        if (callInfo.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<IToken> actualParameters = new HashSet<IToken>();
        for (String formalParameterName : formalParameterNames) {
            String actualParameterName = (String)((AbapMethodCallRecognizer.MethodCallInfo)callInfo.get()).getNamedParameters().get(formalParameterName);
            if (actualParameterName == null) {
                LogManager.getLogger().debug("Found method call that does not declare expected parameter '" + formalParameterName + "' at " + tokens.get(0).getOriginId() + ":" + tokens.get(0).getLineNumber() + ". Ignoring this parameter.");
                continue;
            }
            int indexOfActual = TokenStreamTextUtils.findFirst(tokens, (String)actualParameterName);
            if (indexOfActual == -1) continue;
            actualParameters.add(tokens.get(indexOfActual));
        }
        return actualParameters;
    }
}

