/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.analysislocal;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowGraph;
import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.MethodTaintGraphGenerationAnalysis;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.MethodTaintGraphGenerationAnalysisState;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.TaintInfluenceMap;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallInputValueReference;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallReference;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.MethodCallReturnValueReference;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintAnalysisUtils;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphField;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.util.abap.AbapMethodCallRecognizer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.string.StringUtils;

public class MethodTaintAnalysisCallHandler {
    private ControlFlowNode cfgNode;
    private AbapMethodCallRecognizer.MethodCallInfo methodInvocationDetails;
    private MethodTaintGraphGenerationAnalysisState outState;
    private ControlFlowGraph currentCFG;
    private TokenElementInfo element;
    private TaintInfluenceMap influenceMap;
    private MethodTaintGraphGenerationAnalysis.SSAcreator ssaCreatorForNode;
    private MethodTaintGraphGenerationAnalysisState outStateBeforeCall;
    private StringOffsetTransformer offsetTransformer;
    private LineOffsetConverter rawLineOffsetConverter;

    MethodTaintAnalysisCallHandler(AbapMethodCallRecognizer.MethodCallInfo methodInvocationDetails, MethodTaintGraphGenerationAnalysisState outState, ControlFlowNode cfgNode, ControlFlowGraph currentCFG, TokenElementInfo element, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter, MethodTaintGraphGenerationAnalysis.SSAcreator ssaCreatorForNode, TaintInfluenceMap influenceMap) {
        this.methodInvocationDetails = methodInvocationDetails;
        this.outState = outState;
        this.cfgNode = cfgNode;
        this.currentCFG = currentCFG;
        this.element = element;
        this.ssaCreatorForNode = ssaCreatorForNode;
        this.outStateBeforeCall = MethodTaintGraphGenerationAnalysisState.cloneFrom(outState);
        this.offsetTransformer = offsetTransformer;
        this.rawLineOffsetConverter = rawLineOffsetConverter;
        this.influenceMap = influenceMap;
    }

    void processMethodCall() {
        TextRegionLocation location = TaintAnalysisUtils.createLocationForTokens(this.cfgNode.getTokens(), this.element, this.offsetTransformer, this.rawLineOffsetConverter);
        MethodCallReference callReference = this.createCallReference();
        this.handleExplicitParameters(location, callReference);
        if (this.mayFieldsBeChangedInCall(this.methodInvocationDetails)) {
            this.handleImplicitlyModifiableFields(location, callReference);
        }
    }

    private void handleImplicitlyModifiableFields(TextRegionLocation location, MethodCallReference callReference) {
        Set<TaintGraphField> fieldsBeforeCall = this.outStateBeforeCall.getFieldReferences();
        fieldsBeforeCall.removeAll(this.getFieldsUsedAsParameters());
        Set<TaintGraphField> fieldsAfterCall = this.outState.getFieldReferences();
        HashSet unchangedFields = CollectionUtils.intersectionSet(fieldsBeforeCall, (Collection[])new Collection[]{fieldsAfterCall});
        for (TaintGraphField field : unchangedFields) {
            String actualFieldName = field.getSimpleFieldName();
            Pair<MethodCallInputValueReference, MethodCallReturnValueReference> beforeAfterPair = this.createBeforeAfterParameterPair(callReference, field.getReferenceName(), actualFieldName, MethodCallInputValueReference.EInputParameterType.FIELD, MethodCallReturnValueReference.EReturnParameterType.FIELD, location);
            callReference.getFieldReferences().put(field.getReferenceName(), beforeAfterPair);
        }
    }

    private void handleExplicitParameters(TextRegionLocation location, MethodCallReference callReference) {
        if (!this.methodInvocationDetails.isStaticCall() && this.methodInvocationDetails.getMethodContainerName() != null) {
            callReference.setMethodContainerObjectReference(MethodTaintGraphGenerationAnalysis.getReference(this.methodInvocationDetails.getMethodContainerName(), this.outStateBeforeCall, this.ssaCreatorForNode));
        }
        for (Map.Entry parameter : this.methodInvocationDetails.getChangingParameters().entrySet()) {
            callReference.getNamedParameters().put((String)parameter.getKey(), this.createBeforeAfterParameterPair(callReference, (String)parameter.getKey(), (String)parameter.getValue(), MethodCallInputValueReference.EInputParameterType.NAMED, MethodCallReturnValueReference.EReturnParameterType.CHANGING, location));
        }
        for (Map.Entry parameter : this.methodInvocationDetails.getNamedParameters().entrySet()) {
            callReference.getNamedParameters().put((String)parameter.getKey(), this.createBeforeAfterParameterPair(callReference, (String)parameter.getKey(), (String)parameter.getValue(), MethodCallInputValueReference.EInputParameterType.NAMED, MethodCallReturnValueReference.EReturnParameterType.NAMED, location));
        }
        for (Map.Entry parameter : this.methodInvocationDetails.getImportingParameters().entrySet()) {
            callReference.getNamedParameters().put((String)parameter.getKey(), this.createBeforeAfterParameterPair(callReference, (String)parameter.getKey(), (String)parameter.getValue(), MethodCallInputValueReference.EInputParameterType.NAMED, MethodCallReturnValueReference.EReturnParameterType.IMPORTING, location));
        }
        for (int index = 0; index < this.methodInvocationDetails.getUnnamedParameters().size(); ++index) {
            String actualName = (String)this.methodInvocationDetails.getUnnamedParameters().get(index);
            Pair<MethodCallInputValueReference, MethodCallReturnValueReference> beforeAfterPair = this.createBeforeAfterParameterPair(callReference, String.valueOf(index), actualName, MethodCallInputValueReference.EInputParameterType.UNNAMED, MethodCallReturnValueReference.EReturnParameterType.UNNAMED, location);
            callReference.getUnnamedParameters().add((Object)((MethodCallInputValueReference)beforeAfterPair.getFirst()), (Object)((MethodCallReturnValueReference)beforeAfterPair.getSecond()));
        }
        if (this.methodInvocationDetails.getNamedReturnParameter() != null) {
            String actualName = (String)this.methodInvocationDetails.getNamedReturnParameter().getSecond();
            String formalName = (String)this.methodInvocationDetails.getNamedReturnParameter().getFirst();
            MethodCallReturnValueReference returnValueReference = this.createReturnValueReference(MethodCallReturnValueReference.EReturnParameterType.RECEIVING, location, callReference, actualName, formalName);
            callReference.setNamedReturnParameter((Pair<String, TaintGraphReferenceBase>)new Pair((Object)formalName, (Object)returnValueReference));
        }
        if (this.methodInvocationDetails.getAssignee() != null) {
            String actualName = this.methodInvocationDetails.getAssignee();
            MethodCallReturnValueReference returnValueReference = this.createReturnValueReference(MethodCallReturnValueReference.EReturnParameterType.ASSIGNEE, location, callReference, actualName, "");
            callReference.setUnnamedAssignee(returnValueReference);
        }
    }

    private MethodCallReference createCallReference() {
        MethodCallReference callReference = new MethodCallReference();
        callReference.setCfgNodeId(this.outState.getCFGNodeId());
        callReference.setCallsiteMethodName(this.currentCFG.getMethodName());
        callReference.setMethodName(this.methodInvocationDetails.getMethodName());
        callReference.setMethodContainerName(this.methodInvocationDetails.getMethodContainerName());
        callReference.setStaticCall(this.methodInvocationDetails.isStaticCall());
        return callReference;
    }

    private Set<TaintGraphReferenceBase> getFieldsUsedAsParameters() {
        HashSet actualParameterNames = CollectionUtils.unionSet(this.methodInvocationDetails.getChangingParameters().values(), (Collection[])new Collection[]{this.methodInvocationDetails.getNamedParameters().values(), this.methodInvocationDetails.getImportingParameters().values(), this.methodInvocationDetails.getUnnamedParameters()});
        if (this.methodInvocationDetails.getNamedReturnParameter() != null) {
            actualParameterNames.add((String)this.methodInvocationDetails.getNamedReturnParameter().getSecond());
        }
        if (this.methodInvocationDetails.getAssignee() != null) {
            actualParameterNames.add(this.methodInvocationDetails.getAssignee());
        }
        return actualParameterNames.stream().filter(actualName -> MethodTaintAnalysisCallHandler.mapsToFieldLikeReferenceInState(actualName, this.outStateBeforeCall)).map(actualName -> this.outStateBeforeCall.getReferenceFor((String)actualName)).collect(Collectors.toSet());
    }

    private MethodCallReturnValueReference createReturnValueReference(MethodCallReturnValueReference.EReturnParameterType returnReferenceType, TextRegionLocation location, MethodCallReference callReference, String actualName, String formalName) {
        TaintGraphReferenceBase actual = MethodTaintGraphGenerationAnalysis.getReference(actualName, this.outStateBeforeCall, this.ssaCreatorForNode);
        MethodCallReturnValueReference returnValueReference = new MethodCallReturnValueReference(callReference, returnReferenceType, formalName, (ElementLocation)location, this.currentCFG.getMethodName());
        TaintGraphReferenceBase newSSA = actual.cloneWithNewSSA(this.ssaCreatorForNode.getNextSSA(), (ElementLocation)location);
        this.outState.putReferenceFor(actualName, newSSA);
        HashSet<TaintGraphReferenceBase> newSSAInfluenceSet = new HashSet<TaintGraphReferenceBase>(1);
        newSSAInfluenceSet.add(returnValueReference);
        this.influenceMap.addInfluenceOn(newSSA, newSSAInfluenceSet);
        return returnValueReference;
    }

    private boolean mayFieldsBeChangedInCall(AbapMethodCallRecognizer.MethodCallInfo callDetails) {
        return !callDetails.isFunctionCall() && !this.element.getUniformPath().contains("FUGR");
    }

    private static boolean mapsToFieldLikeReferenceInState(String variableName, MethodTaintGraphGenerationAnalysisState state) {
        TaintGraphReferenceBase actualParameter;
        return state.containsReferenceFor(variableName) && ((actualParameter = state.getReferenceFor(variableName)).getType() == TaintGraphReferenceBase.EReferenceType.FIELD || actualParameter.getType() == TaintGraphReferenceBase.EReferenceType.METHOD_CALL_RETURN && ((MethodCallReturnValueReference)actualParameter).getReturnValueType() == MethodCallReturnValueReference.EReturnParameterType.FIELD);
    }

    private Pair<MethodCallInputValueReference, MethodCallReturnValueReference> createBeforeAfterParameterPair(MethodCallReference callReference, String formalParameterName, String actualParameterName, MethodCallInputValueReference.EInputParameterType inputParameterType, MethodCallReturnValueReference.EReturnParameterType returnParameterType, TextRegionLocation location) {
        MethodCallInputValueReference actualInput = new MethodCallInputValueReference(callReference, inputParameterType, formalParameterName, (ElementLocation)location, this.outState.getMethodIdentifier());
        MethodCallReturnValueReference returnValueReference = new MethodCallReturnValueReference(callReference, returnParameterType, formalParameterName, (ElementLocation)location, this.outState.getMethodIdentifier());
        Pair beforeAfterPair = new Pair((Object)actualInput, (Object)returnValueReference);
        if (!MethodTaintAnalysisCallHandler.isConstantValue(actualParameterName)) {
            TaintGraphReferenceBase actual = MethodTaintGraphGenerationAnalysis.getReference(actualParameterName, this.outStateBeforeCall, this.ssaCreatorForNode);
            TaintGraphReferenceBase newActualSSA = actual.cloneWithNewSSA(this.ssaCreatorForNode.getNextSSA(), (ElementLocation)location);
            this.influenceMap.addInfluenceOn(actualInput, this.influenceMap.getInfluencesRecursiveOn(actual));
            this.outState.putReferenceFor(actualParameterName, newActualSSA);
            HashSet<TaintGraphReferenceBase> newSSAInfluenceSet = new HashSet<TaintGraphReferenceBase>(1);
            newSSAInfluenceSet.add(returnValueReference);
            this.influenceMap.addInfluenceOn(newActualSSA, newSSAInfluenceSet);
        }
        return beforeAfterPair;
    }

    private static boolean isConstantValue(String potentialConstant) {
        return potentialConstant.startsWith("'") && potentialConstant.endsWith("'") || StringUtils.isInteger((String)potentialConstant);
    }
}

