/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.analysislocal;

import com.teamscale.index.dataflow.controlflowgraph.ControlFlowNode;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.MethodTaintGraphGenerationAnalysis;
import com.teamscale.index.dataflow.taintpropagation.analysislocal.MethodTaintGraphGenerationAnalysisState;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintAnalysisUtils;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphField;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphSource;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.Iterator;
import java.util.List;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.LineOffsetConverter;

public class TaintSourceRecognizer {
    public static PairList<TaintGraphSource, TaintGraphReferenceBase> getSourceRelations(ControlFlowNode node, MethodTaintGraphGenerationAnalysisState state, MethodTaintGraphGenerationAnalysis.SSAcreator ssaCreator, TokenElementInfo element, StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
        if (node.isSynthetic() || node.getTokens().isEmpty()) {
            return PairList.emptyPairList();
        }
        OffsetTransformationHelper offsetTransformationHelper = new OffsetTransformationHelper(offsetTransformer, rawLineOffsetConverter);
        return switch (element.getLanguage()) {
            case ELanguage.ABAP -> TaintSourceRecognizer.getAbapSourceRelations(node, state, ssaCreator, element, offsetTransformationHelper);
            default -> PairList.emptyPairList();
        };
    }

    private static PairList<TaintGraphSource, TaintGraphReferenceBase> getAbapSourceRelations(ControlFlowNode node, MethodTaintGraphGenerationAnalysisState state, MethodTaintGraphGenerationAnalysis.SSAcreator ssaCreator, TokenElementInfo element, OffsetTransformationHelper offsetTransformationHelper) {
        PairList sourceRelations = new PairList();
        List<IToken> tokens = node.getTokens();
        if (tokens.size() <= 2) {
            return PairList.emptyPairList();
        }
        if (tokens.get(0).getType() == ETokenType.PARAMETERS || tokens.get(0).getType() == ETokenType.PARAMETER) {
            String parameterName = tokens.get(1).getText().toLowerCase();
            StringOffsetTransformer offsetTransformer = offsetTransformationHelper.getOffsetTransformer();
            LineOffsetConverter rawLineOffsetConverter = offsetTransformationHelper.getRawLineOffsetConverter();
            TextRegionLocation location = TaintAnalysisUtils.createLocationForTokens(tokens, element, offsetTransformer, rawLineOffsetConverter);
            TaintGraphField parameterField = new TaintGraphField(element.getUniformPath(), parameterName, location, ssaCreator.getNextSSA(), state.getMethodIdentifier());
            state.putReferenceFor(parameterName, parameterField);
            sourceRelations.add((Object)new TaintGraphSource(tokens.get(1), parameterName, TaintAnalysisUtils.createLocationForTokens(tokens, element, offsetTransformer, rawLineOffsetConverter), state.getMethodIdentifier()), (Object)parameterField);
        }
        TaintSourceRecognizer.addAbapGetFormFieldSourceRelations((PairList<TaintGraphSource, TaintGraphReferenceBase>)sourceRelations, tokens, state, ssaCreator, element, offsetTransformationHelper);
        return sourceRelations;
    }

    private static void addAbapGetFormFieldSourceRelations(PairList<TaintGraphSource, TaintGraphReferenceBase> sourceRelations, List<IToken> tokens, MethodTaintGraphGenerationAnalysisState state, MethodTaintGraphGenerationAnalysis.SSAcreator ssaCreator, TokenElementInfo element, OffsetTransformationHelper offsetTransformationHelper) {
        List sequenceIndices = TokenStreamUtils.allStartingIndicesOfTypeSequence(tokens, (int)0, (int)tokens.size(), (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.ARROW, ETokenType.IDENTIFIER});
        Iterator iterator = sequenceIndices.iterator();
        while (iterator.hasNext()) {
            int eqTokenIndex;
            int sequenceIndex = (Integer)iterator.next();
            if (sequenceIndex == -1 || !tokens.get(sequenceIndex + 2).getText().equalsIgnoreCase("get_form_field") || (eqTokenIndex = TokenStreamUtils.lastTokenMatching(tokens, (int)0, (int)sequenceIndex, (ITokenMatcher)ETokenType.EQ)) < 1) continue;
            int assignedVariableIndex = eqTokenIndex - 1;
            if (tokens.get(assignedVariableIndex).getType() != ETokenType.IDENTIFIER) {
                if (tokens.get(assignedVariableIndex).getType() != ETokenType.RPAREN || eqTokenIndex < 2 || tokens.get(eqTokenIndex - 2).getType() != ETokenType.IDENTIFIER) continue;
                assignedVariableIndex = eqTokenIndex - 2;
            }
            TaintSourceRecognizer.addSingleAbapSourceRelation(sourceRelations, tokens, assignedVariableIndex, state, ssaCreator, element, offsetTransformationHelper);
        }
    }

    private static void addSingleAbapSourceRelation(PairList<TaintGraphSource, TaintGraphReferenceBase> sourceRelations, List<IToken> tokens, int tokenIndex, MethodTaintGraphGenerationAnalysisState state, MethodTaintGraphGenerationAnalysis.SSAcreator ssaCreator, TokenElementInfo element, OffsetTransformationHelper offsetTransformationHelper) {
        StringOffsetTransformer offsetTransformer = offsetTransformationHelper.getOffsetTransformer();
        LineOffsetConverter rawLineOffsetConverter = offsetTransformationHelper.getRawLineOffsetConverter();
        String parameterName = tokens.get(tokenIndex).getText().toLowerCase();
        TextRegionLocation location = TaintAnalysisUtils.createLocationForTokens(tokens, element, offsetTransformer, rawLineOffsetConverter);
        TaintGraphField parameterField = new TaintGraphField(element.getUniformPath(), parameterName, location, ssaCreator.getNextSSA(), state.getMethodIdentifier());
        state.putReferenceFor(parameterName, parameterField);
        sourceRelations.add((Object)new TaintGraphSource(tokens.get(tokenIndex), parameterName, TaintAnalysisUtils.createLocationForTokens(tokens, element, offsetTransformer, rawLineOffsetConverter), state.getMethodIdentifier()), (Object)parameterField);
    }

    private static class OffsetTransformationHelper {
        private final StringOffsetTransformer offsetTransformer;
        private final LineOffsetConverter rawLineOffsetConverter;

        private OffsetTransformationHelper(StringOffsetTransformer offsetTransformer, LineOffsetConverter rawLineOffsetConverter) {
            this.offsetTransformer = offsetTransformer;
            this.rawLineOffsetConverter = rawLineOffsetConverter;
        }

        private StringOffsetTransformer getOffsetTransformer() {
            return this.offsetTransformer;
        }

        private LineOffsetConverter getRawLineOffsetConverter() {
            return this.rawLineOffsetConverter;
        }
    }
}

