/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph;

import com.teamscale.index.dataflow.taintpropagation.methodindex.methodtaintgraph.TaintGraphReferenceBase;
import java.util.EnumSet;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class VariableTaintGraphReference
extends TaintGraphReferenceBase {
    private static final long serialVersionUID = 1L;
    private static final EnumSet<TaintGraphReferenceBase.EReferenceType> ALLOWED_SIMPLE_TYPES = EnumSet.of(TaintGraphReferenceBase.EReferenceType.LOCAL, TaintGraphReferenceBase.EReferenceType.RETURN_VALUE);
    private final TaintGraphReferenceBase.EReferenceType type;

    public VariableTaintGraphReference(String referenceName, String ssaIndex, TaintGraphReferenceBase.EReferenceType type, ElementLocation location, String referenceContainerMethodId) {
        super(referenceName, ssaIndex, location, referenceContainerMethodId);
        CCSMAssert.isTrue((boolean)ALLOWED_SIMPLE_TYPES.contains((Object)type), (String)("Can't construct a TaintGraphReferenceSimple of type " + String.valueOf((Object)type)));
        CCSMAssert.isNotNull((Object)referenceName);
        this.type = type;
    }

    @Override
    public TaintGraphReferenceBase.EReferenceType getType() {
        return this.type;
    }

    public String toString() {
        switch (this.getType()) {
            case LOCAL: {
                return "L_" + this.getReferenceName() + "^" + this.getSsaIndex();
            }
            case RETURN_VALUE: {
                return "R_" + this.getReferenceName() + "^" + this.getSsaIndex();
            }
        }
        CCSMAssert.fail((String)("Type " + String.valueOf((Object)this.getType()) + " not allowed in TaintGraphReferenceSimple."));
        return "";
    }

    @Override
    public TaintGraphReferenceBase cloneWithNewSSA(String newSSAIndex, ElementLocation location) {
        return new VariableTaintGraphReference(this.getReferenceName(), newSSAIndex, this.getType(), location, this.referenceContainerMethodId);
    }

    @Override
    public String toFindingDescription() {
        return "Variable '" + this.getReferenceName() + "' may be tainted.";
    }
}

