/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external;

import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.index.CommitAssociatedObjectBase;
import com.teamscale.index.external.input.ExternalAnalysisSessionInfo;
import com.teamscale.index.external.status.EExternalAnalysisResultType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.store.util.StorageKey;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class ExternalAnalysisCommitInfo
extends CommitAssociatedObjectBase {
    private static final long serialVersionUID = 1L;
    private final String username;
    private final String message;
    private final String partition;
    private final String sessionId;
    private final FileDelta fileDelta;
    private final long uploadTimestamp;
    private final Set<EExternalAnalysisResultType> types;

    public ExternalAnalysisCommitInfo(CommitDescriptor commit, String username, String message, String partition, String sessionId, KeyDelta fileDelta, long uploadTimestamp, Set<EExternalAnalysisResultType> types) {
        super(commit);
        this.username = username;
        this.message = message;
        this.partition = partition;
        this.fileDelta = new FileDelta(fileDelta);
        this.sessionId = sessionId;
        this.uploadTimestamp = uploadTimestamp;
        this.types = types;
    }

    public ExternalAnalysisCommitInfo(ExternalAnalysisCommitInfo other, KeyDelta fileDelta) {
        this(other.getCommit(), other.username, other.message, other.partition, null, fileDelta, other.getUploadTimestamp(), other.types);
    }

    public ExternalAnalysisCommitInfo(ExternalAnalysisCommitInfo other, KeyDelta fileDelta, String partition) {
        this(other.getCommit(), other.username, other.message, partition, null, fileDelta, other.getUploadTimestamp(), other.types);
    }

    public ExternalAnalysisCommitInfo(CommitDescriptor commit, ExternalAnalysisSessionInfo session, KeyDelta fileDelta, Set<EExternalAnalysisResultType> types) {
        this(commit, session.getUsername(), session.getMessageWithPartition(), session.getPartition(), session.getSessionId(), fileDelta, session.getUploadTimestamp(), types);
    }

    public String getUsername() {
        return this.username;
    }

    public String getMessage() {
        return this.message;
    }

    public String getPartition() {
        return this.partition;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public KeyDelta getFileDelta() {
        return this.fileDelta.toKeyDelta();
    }

    public long getUploadTimestamp() {
        return this.uploadTimestamp;
    }

    public Set<EExternalAnalysisResultType> getTypes() {
        return this.types;
    }

    public String toString() {
        return "ExternalAnalysisCommitInfo [username=" + this.username + ", message=" + this.message + ", partition=" + this.partition + ", fileDelta=" + String.valueOf(this.fileDelta) + "]";
    }

    @IndexValueClass(containedInBackup=true)
    private static final class FileDelta
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<StorageKey> addedOrChanged;
        private final List<StorageKey> deleted;

        public FileDelta(KeyDelta keyDelta) {
            this.addedOrChanged = new ArrayList<StorageKey>((Collection<StorageKey>)keyDelta.getAddedOrChangedKeys());
            this.deleted = new ArrayList<StorageKey>((Collection<StorageKey>)keyDelta.getDeletedKeys());
        }

        public KeyDelta toKeyDelta() {
            return new KeyDelta(this.addedOrChanged, this.deleted);
        }

        public String toString() {
            return "added/changed: " + String.valueOf(this.addedOrChanged) + ", deleted: " + String.valueOf(this.deleted);
        }
    }
}

