/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.input.info;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.external.input.info.ExternalAnalysisImportInfo;
import com.teamscale.index.external.input.info.ILineAdjustable;
import com.teamscale.index.external.result.ExternalAnalysisResult;
import com.teamscale.index.external.result.ExternalAnalysisResultLineCoverage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.commons.findings.location.ILineAdjuster;
import org.conqat.engine.commons.findings.location.SimpleValidLinesFilter;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.engine.sourcecode.coverage.TestCoverageUtils;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class ExternalAnalysisImportInfoLineCoverage
extends ExternalAnalysisImportInfo<LineCoverageInfo>
implements ILineAdjustable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long serialVersionUID = 1L;
    private static final String LINE_COVERAGE_PROPERTY = "lineCoverage";
    @JsonProperty(value="lineCoverage")
    private LineCoverageInfo lineCoverage;

    @JsonCreator
    public ExternalAnalysisImportInfoLineCoverage(@JsonProperty(value="uniformPath") String uniformPath, @JsonProperty(value="lineCoverage") LineCoverageInfo lineCoverage) {
        super(uniformPath);
        this.lineCoverage = lineCoverage;
    }

    public void adjustCoverage(ILineAdjuster adjuster, String uniformPath) {
        this.lineCoverage = TestCoverageUtils.adjustCoverageInfo((LineCoverageInfo)this.lineCoverage, (ILineAdjuster)adjuster, (String)("Performing coverage line adjustment in file \"" + uniformPath + "\""));
    }

    @Override
    public LineCoverageInfo getData() {
        return this.lineCoverage;
    }

    public ExternalAnalysisResultLineCoverage createAnalysisResult() {
        return new ExternalAnalysisResultLineCoverage(this.lineCoverage);
    }

    @Override
    public long getEstimatedSizeBytes() {
        return this.lineCoverage.getEstimatedSizeBytes() + super.getEstimatedSizeBytes();
    }

    public ExternalAnalysisImportInfoLineCoverage merge(ExternalAnalysisImportInfo<?> infoToMerge) {
        CCSMAssert.isTrue((boolean)this.getUniformPath().equals(infoToMerge.getUniformPath()), (String)"ExternalAnalysisImportInfo info for different uniform paths '%s' and '%s' may not be merged.".formatted(this.getUniformPath(), infoToMerge.getUniformPath()));
        CCSMAssert.isTrue((boolean)this.getPartition().equals(infoToMerge.getPartition()), (String)"ExternalAnalysisImportInfo for different partitions '%s' and '%s' may not be merged.".formatted(this.getPartition(), infoToMerge.getPartition()));
        CCSMAssert.isTrue((this.getRepositoryId() == null && infoToMerge.getRepositoryId() == null || this.getRepositoryId() != null && this.getRepositoryId().equals(infoToMerge.getRepositoryId()) ? 1 : 0) != 0, (String)"ExternalAnalysisImportInfo for different repositories '%s' and '%s' may not be merged.".formatted(this.getRepositoryId(), infoToMerge.getRepositoryId()));
        if (infoToMerge instanceof ExternalAnalysisImportInfoLineCoverage) {
            ExternalAnalysisImportInfoLineCoverage externalAnalysisImportInfoLineCoverage = (ExternalAnalysisImportInfoLineCoverage)infoToMerge;
            LineCoverageInfo mergedLineCoverage = LineCoverageInfo.mergeInfos((LineCoverageInfo)this.getData(), (LineCoverageInfo)externalAnalysisImportInfoLineCoverage.getData());
            ExternalAnalysisImportInfoLineCoverage mergedInfo = new ExternalAnalysisImportInfoLineCoverage(this.getUniformPath(), mergedLineCoverage);
            mergedInfo.setPartition(this.getPartition());
            mergedInfo.setRepositoryId(this.getRepositoryId());
            mergedInfo.addUniformPaths(this.getReportUniformPaths());
            mergedInfo.addUniformPaths(externalAnalysisImportInfoLineCoverage.getReportUniformPaths());
            return mergedInfo;
        }
        LOGGER.error("Skipped merging ExternalAnalysisImportInfo of types '{}' and '{}'. Only instances of the same class may be merged.", this.getClass(), infoToMerge.getClass());
        return null;
    }

    @Override
    public ExternalAnalysisResult<?> createAdjustedAnalysisResult(TokenElementLineInfo lineInfo, String uniformPath) {
        SimpleValidLinesFilter locationAdjuster = new SimpleValidLinesFilter(lineInfo.getLineCount());
        return new ExternalAnalysisResultLineCoverage(TestCoverageUtils.adjustCoverageInfo((LineCoverageInfo)this.lineCoverage, (ILineAdjuster)locationAdjuster, (String)("Adjust line based coverage for file \"" + uniformPath + "\"")));
    }
}

