/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.external.status;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.external.status.EExternalAnalysisProcessingStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass
public class ExternalAnalysisProcessingStepInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String STATUS_PROPERTY = "status";
    private static final String SUCCESSFUL_PROPERTY = "successful";
    private static final String TIMESTAMP_PROPERTY = "timestamp";
    @JsonProperty(value="status")
    private final EExternalAnalysisProcessingStatus status;
    @JsonProperty(value="successful")
    private final boolean successful;
    @JsonProperty(value="timestamp")
    private long timestamp;
    @JsonProperty(value="messages")
    private @Nullable List<String> messages;

    public ExternalAnalysisProcessingStepInfo(EExternalAnalysisProcessingStatus status, boolean successful) {
        this(status, successful, System.currentTimeMillis());
    }

    @JsonCreator
    public ExternalAnalysisProcessingStepInfo(@JsonProperty(value="status") EExternalAnalysisProcessingStatus status, @JsonProperty(value="successful") boolean successful, @JsonProperty(value="timestamp") long timestamp) {
        this.status = status;
        this.successful = successful;
        this.timestamp = timestamp;
    }

    public boolean hasEqualProperties(List<String> statusMessages, EExternalAnalysisProcessingStatus processingStatus, boolean successful) {
        return this.isSuccessful() == successful && this.getMessages().equals(statusMessages) && this.getStatus() == processingStatus;
    }

    public void addMessages(List<String> messages) {
        if (this.messages == null) {
            this.messages = new ArrayList<String>();
        }
        this.messages.addAll(messages);
    }

    public void addMessage(String message) {
        this.addMessages(Collections.singletonList(message));
    }

    public EExternalAnalysisProcessingStatus getStatus() {
        return this.status;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public List<String> getMessages() {
        if (this.messages == null) {
            return Collections.emptyList();
        }
        return this.messages;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void updateTimestamp() {
        this.timestamp = System.currentTimeMillis();
    }
}

