/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.calculation;

import com.teamscale.core.index.CommitDescriptorIndex;
import com.teamscale.core.user.User;
import com.teamscale.index.blacklisting.FindingBlacklistInfo;
import com.teamscale.index.findings.calculation.AffectedFilesUtils;
import com.teamscale.index.findings.calculation.BasicFindingFilterUtils;
import com.teamscale.index.findings.calculation.BasicFindingsFilterSettings;
import com.teamscale.index.findings.calculation.FilteredFindingsList;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.findings.calculation.FindingsFilterSettings;
import com.teamscale.index.findings.calculation.IFindingsRetriever;
import com.teamscale.index.findings.calculation.TokenElementChurnInfo;
import com.teamscale.index.issues.WorkItemHistoryIndexAggregation;
import com.teamscale.index.query.QueryableEntityUtils;
import com.teamscale.index.query.StoredQueryDescriptor;
import com.teamscale.index.query.StoredQueryIndex;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndex;
import com.teamscale.index.tracking.ExtendedTrackedFinding;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import jakarta.ws.rs.NotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.ITeamscaleIssueFindingLocation;
import org.conqat.engine.commons.findings.location.QualifiedNameLocation;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class FindingFilterUtils {
    public static @NonNull FilteredFindingsList applyFindingFilter(UniformPath uniformPath, FindingsFilterSettings filterSettings, CommitDescriptor commitDescriptor, List<ExtendedTrackedFinding> filteredFindings, FindingsCalculationInfo calculationInfo, User user) throws StorageException, QueryCompilationException, QueryParsingException {
        IFindingsRetriever findingsRetriever = IFindingsRetriever.getFindingsRetriever(filterSettings.isOnlySpecItemFindings(), uniformPath.isNonCodePath(), commitDescriptor.getBranchName(), calculationInfo);
        filteredFindings = FindingFilterUtils.applySpecItemQueryFilter(filterSettings, commitDescriptor, filteredFindings, calculationInfo, user);
        filteredFindings = FindingFilterUtils.applyIssueQueryFilter(filterSettings, commitDescriptor, filteredFindings, calculationInfo, user);
        filteredFindings = FindingFilterUtils.filterByBaseline(uniformPath, filteredFindings, filterSettings, calculationInfo, commitDescriptor, findingsRetriever);
        filteredFindings = FindingFilterUtils.filterByExclusionRationale(filteredFindings, filterSettings.getBlacklistRationaleFilter());
        filteredFindings = FindingFilterUtils.filterFindingsByQualifiedName(filteredFindings, filterSettings);
        return BasicFindingFilterUtils.filterFindings(filteredFindings, (BasicFindingsFilterSettings)filterSettings, calculationInfo);
    }

    private static List<ExtendedTrackedFinding> applyIssueQueryFilter(FindingsFilterSettings filterSettings, CommitDescriptor commitDescriptor, List<ExtendedTrackedFinding> filteredFindings, FindingsCalculationInfo calculationInfo, User user) throws StorageException, QueryCompilationException, QueryParsingException {
        if (StringUtils.isEmpty((String)filterSettings.getStoredIssueQuery()) && StringUtils.isEmpty((String)filterSettings.getCustomIssueQuery())) {
            return filteredFindings;
        }
        Set<TeamscaleIssueId> matchedIssues = FindingFilterUtils.resolveIssues(filterSettings, commitDescriptor, calculationInfo, user);
        ArrayList<CommitDescriptor> issueCommits = new ArrayList<CommitDescriptor>(FindingFilterUtils.getIssueCommits(commitDescriptor, calculationInfo, matchedIssues));
        Set affectedPaths = AffectedFilesUtils.getAffectedCodeFiles(calculationInfo.projectStorageSystem(), issueCommits).stream().map(TokenElementChurnInfo::getUniformPath).collect(Collectors.toSet());
        return filteredFindings.stream().filter(finding -> affectedPaths.contains(finding.getLocation().getUniformPath())).toList();
    }

    private static Set<TeamscaleIssueId> resolveIssues(FindingsFilterSettings filterSettings, CommitDescriptor commitDescriptor, FindingsCalculationInfo calculationInfo, User user) throws StorageException, QueryCompilationException, QueryParsingException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)commitDescriptor);
        HashSet<TeamscaleIssueId> matchedIssues = new HashSet<TeamscaleIssueId>();
        if (!StringUtils.isEmpty((String)filterSettings.getStoredIssueQuery())) {
            StoredQueryDescriptor queryDescriptor = StoredQueryIndex.openIndex(calculationInfo.projectStorageSystem(), StoredQueryIndex.EStoredQueryType.ISSUE).getQuery(filterSettings.getStoredIssueQuery()).orElseThrow(() -> new NotFoundException("Could not find stored issue query: " + filterSettings.getStoredIssueQuery()));
            matchedIssues.addAll(FindingFilterUtils.queryIssues(calculationInfo, user, historyAccessOption, queryDescriptor.getQuery()));
        }
        if (!StringUtils.isEmpty((String)filterSettings.getCustomIssueQuery())) {
            matchedIssues.addAll(FindingFilterUtils.queryIssues(calculationInfo, user, historyAccessOption, filterSettings.getCustomIssueQuery()));
        }
        return matchedIssues;
    }

    private static Set<TeamscaleIssueId> queryIssues(FindingsCalculationInfo calculationInfo, User user, HistoryAccessOption historyAccessOption, String query) throws StorageException, QueryCompilationException, QueryParsingException {
        return QueryableEntityUtils.performQueryWithEmptyHandling(query, WorkItemHistoryIndexAggregation.forIssues(calculationInfo.projectStorageSystem(), historyAccessOption), QueryableEntityUtils.QueryContext.ofTimestamp(calculationInfo.projectStorageSystem(), calculationInfo.indexLayer().openGlobalStorageSystem(), user, StoredQueryIndex.EStoredQueryType.ISSUE, historyAccessOption)).stream().map(TeamscaleIssueId::fromInternalId).collect(Collectors.toSet());
    }

    private static Set<CommitDescriptor> getIssueCommits(CommitDescriptor upperBoundary, FindingsCalculationInfo calculationInfo, Set<TeamscaleIssueId> matchedIssues) throws StorageException {
        RepositoryCommitIssueMappingIndex commitMappingIndex = (RepositoryCommitIssueMappingIndex)calculationInfo.projectStorageSystem().openProjectIndex(RepositoryCommitIssueMappingIndex.class, null);
        Set issueCommits = ((Set)commitMappingIndex.getCommitsForIssues(new ArrayList<TeamscaleIssueId>(matchedIssues)).getValues()).stream().filter(commit -> commit.getTimestamp() <= upperBoundary.getTimestamp()).collect(Collectors.toSet());
        if (issueCommits.isEmpty()) {
            return Collections.emptySet();
        }
        CommitDescriptorIndex commitDescriptorIndex = (CommitDescriptorIndex)calculationInfo.projectStorageSystem().openProjectIndex(CommitDescriptorIndex.class, null);
        HashSet<CommitDescriptor> result = new HashSet<CommitDescriptor>();
        commitDescriptorIndex.getCommitHistoryCollector(upperBoundary).scanStartTimestamp(issueCommits.stream().mapToLong(CommitDescriptor::getTimestamp).min().orElse(upperBoundary.getTimestamp()) - 1L, commit -> {
            if (commit.isMergeCommit()) {
                return;
            }
            CommitDescriptor unparantedCommit = new CommitDescriptor((CommitDescriptor)commit);
            if (issueCommits.contains(unparantedCommit)) {
                result.add(unparantedCommit);
            }
        });
        return result;
    }

    private static List<ExtendedTrackedFinding> applySpecItemQueryFilter(FindingsFilterSettings findingsFilterSettings, CommitDescriptor commitDescriptor, List<ExtendedTrackedFinding> specItemFindings, FindingsCalculationInfo calculationInfo, User user) throws StorageException, QueryCompilationException, QueryParsingException {
        String specItemQuery = findingsFilterSettings.getSpecItemQuery();
        if (findingsFilterSettings.isOnlySpecItemFindings() && !StringUtils.isEmpty((String)specItemQuery)) {
            HashSet<String> idsForQueriedItems = new HashSet<String>(FindingFilterUtils.getIdsForQueriedItems(specItemQuery, commitDescriptor, calculationInfo, user));
            return specItemFindings.stream().filter(trackedFinding -> idsForQueriedItems.contains(((ITeamscaleIssueFindingLocation)trackedFinding.getLocation()).getIssueId())).collect(Collectors.toList());
        }
        return specItemFindings;
    }

    private static List<String> getIdsForQueriedItems(String specItemQuery, CommitDescriptor commitDescriptor, FindingsCalculationInfo calculationInfo, User user) throws StorageException, QueryCompilationException, QueryParsingException {
        HistoryAccessOption historyAccessOption = HistoryAccessOption.readCommit((CommitDescriptor)commitDescriptor);
        WorkItemHistoryIndexAggregation<SpecItem> specItemHistoryIndexAggregation = WorkItemHistoryIndexAggregation.forSpecItems(calculationInfo.projectStorageSystem(), historyAccessOption);
        return QueryableEntityUtils.performQueryWithEmptyHandling(specItemQuery, specItemHistoryIndexAggregation, QueryableEntityUtils.QueryContext.ofTimestamp(calculationInfo.projectStorageSystem(), calculationInfo.indexLayer().openGlobalStorageSystem(), user, StoredQueryIndex.EStoredQueryType.SPEC_ITEM, historyAccessOption));
    }

    private static List<ExtendedTrackedFinding> filterByBaseline(UniformPath uniformPath, List<ExtendedTrackedFinding> findings, FindingsFilterSettings filterSettings, FindingsCalculationInfo calculationInfo, CommitDescriptor commitDescriptor, IFindingsRetriever findingsRetriever) throws StorageException {
        long baselineTimestamp = filterSettings.getBaseline().resolve(calculationInfo.projectStorageSystem());
        if (baselineTimestamp <= 0L) {
            return findings;
        }
        List<ExtendedTrackedFinding> filteredFindings = new ArrayList<ExtendedTrackedFinding>();
        ArrayList<ExtendedTrackedFinding> baselineRejected = new ArrayList<ExtendedTrackedFinding>();
        String branch = commitDescriptor.getBranchName();
        FindingFilterUtils.splitFindingsByBaseline(uniformPath, findings, baselineTimestamp, branch, baselineRejected, filteredFindings, findingsRetriever);
        boolean includeChangedCodeFindings = filterSettings.isIncludeChangedCodeFindings();
        boolean onlyChangedCodeFindings = filterSettings.isOnlyChangedCodeFindings();
        if (!includeChangedCodeFindings && !onlyChangedCodeFindings) {
            return filteredFindings;
        }
        List<ExtendedTrackedFinding> findingsInChangedCode = findingsRetriever.getFindingsInChangedCode(baselineTimestamp, commitDescriptor, baselineRejected);
        if (includeChangedCodeFindings) {
            filteredFindings.addAll(findingsInChangedCode);
        } else {
            filteredFindings = findingsInChangedCode;
        }
        return filteredFindings;
    }

    private static void splitFindingsByBaseline(UniformPath uniformPath, List<ExtendedTrackedFinding> findings, long baselineTimestamp, String branch, List<ExtendedTrackedFinding> baselineRejected, List<ExtendedTrackedFinding> baselinedFindings, IFindingsRetriever findingsRetriever) throws StorageException {
        Set<String> findingsAtBaseline = findingsRetriever.getFindingIds(uniformPath.toString(), new CommitDescriptor(branch, baselineTimestamp));
        for (ExtendedTrackedFinding finding : findings) {
            boolean isReincarnatedFinding = findingsAtBaseline.contains(finding.getId());
            if (finding.getBirthCommit().getTimestamp() <= baselineTimestamp || isReincarnatedFinding) {
                baselineRejected.add(finding);
                continue;
            }
            baselinedFindings.add(finding);
        }
    }

    private static List<ExtendedTrackedFinding> filterByExclusionRationale(List<ExtendedTrackedFinding> findings, Pattern rationale) {
        if (rationale == null) {
            return findings;
        }
        return CollectionUtils.filter(findings, finding -> rationale.matcher(finding.getBlacklistInfo().map(FindingBlacklistInfo::getRationale).orElse("")).find());
    }

    private static List<ExtendedTrackedFinding> filterFindingsByQualifiedName(List<ExtendedTrackedFinding> findings, FindingsFilterSettings findingsFilterSettings) {
        String targetLayerQualifiedName = findingsFilterSettings.getQualifiedName();
        if (StringUtils.isEmpty((String)targetLayerQualifiedName)) {
            return findings;
        }
        ArrayList<ExtendedTrackedFinding> selectedFindings = new ArrayList<ExtendedTrackedFinding>();
        for (ExtendedTrackedFinding finding : findings) {
            if (!FindingFilterUtils.isFindingRelevantForQualifiedNameView(targetLayerQualifiedName, finding)) continue;
            selectedFindings.add(finding);
        }
        return selectedFindings;
    }

    private static boolean isFindingRelevantForQualifiedNameView(String targetQualifiedName, TrackedFinding finding) {
        if (finding.getLocation() instanceof QualifiedNameLocation) {
            if (FindingFilterUtils.isQualifiedNameLocationAtOrDirectlyBelowTargetLocation(finding.getLocation(), targetQualifiedName)) {
                return true;
            }
            for (ElementLocation secondaryLocation : finding.getSecondaryLocations()) {
                if (!FindingFilterUtils.isQualifiedNameLocationAtOrDirectlyBelowTargetLocation(secondaryLocation, targetQualifiedName)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isQualifiedNameLocationAtOrDirectlyBelowTargetLocation(ElementLocation location, String targetQualifiedName) {
        if (!(location instanceof QualifiedNameLocation)) {
            return false;
        }
        QualifiedNameLocation qualifiedNameLocation = (QualifiedNameLocation)location;
        String findingLocationQualifiedName = qualifiedNameLocation.getQualifiedName();
        if (targetQualifiedName.equals(findingLocationQualifiedName)) {
            return true;
        }
        if (findingLocationQualifiedName.startsWith(targetQualifiedName)) {
            String suffix = findingLocationQualifiedName.substring(targetQualifiedName.length());
            int numberOfSubBlocks = StringUtils.countCharacter((String)suffix, (char)'/');
            return numberOfSubBlocks == 1;
        }
        return false;
    }

    private FindingFilterUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

