/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.calculation;

import com.teamscale.core.analysis.configuration.ConfigurationTemplateManager;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.AnalysisGroup;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.index.model.QualityIndicator;
import com.teamscale.core.analysis.configuration.model.AnalysisGroupDescriptor;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.configuration.model.ConfigurationItemBase;
import com.teamscale.core.analysis.configuration.model.FindingDescriptor;
import com.teamscale.core.findings.FindingTypeDescription;
import com.teamscale.core.findings.FindingsSchemaIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.configuration.AnalysisProfileUtils;
import com.teamscale.index.findings.calculation.FindingsCalculationInfo;
import com.teamscale.index.findings.calculation.GuidelineSummaryCalculator;
import eu.cqse.check.framework.core.registry.GuidelineMapping;
import eu.cqse.check.framework.core.ruleset.RulesetInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.FindingsSummaryCategoryInfo;
import org.conqat.engine.index.shared.FindingsSummaryGroupInfo;
import org.conqat.engine.index.shared.FindingsSummaryGuidelineInfo;
import org.conqat.engine.index.shared.FindingsSummaryInfo;
import org.conqat.engine.index.shared.FindingsSummaryTypeIdInfo;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.index.shared.TrackedFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assessment.ETrafficLightColor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.TwoDimHashMap;
import org.conqat.lib.commons.collections.UnmodifiableList;

public class FindingsSummaryCalculator {
    private static final Logger LOGGER = LogManager.getLogger();
    private final TwoDimHashMap<String, String, CounterSet<ETrafficLightColor>> findingGroupCounts = new TwoDimHashMap();
    private final TwoDimHashMap<String, String, CounterSet<ETrafficLightColor>> findingTypeIdCounts = new TwoDimHashMap();
    private final CounterSet<String> findingGuidelineCounts = new CounterSet();
    private final Map<String, CounterSet<String>> findingGuidelineRuleCounts = new HashMap<String, CounterSet<String>>();
    private final Map<RulesetInfo, CounterSet<ETrafficLightColor>> rulesCounter = new HashMap<RulesetInfo, CounterSet<ETrafficLightColor>>();
    private final Map<String, CodeScopeName> allTypeIds = new HashMap<String, CodeScopeName>();

    public static <T extends TrackedFinding> FindingsSummaryInfo createFindingsSummary(List<T> findings, boolean reportCategoriesWithoutFindings, boolean reportRulesWithoutFindings, FindingsCalculationInfo calculationInfo) throws StorageException {
        FindingsSummaryCalculator calculator = new FindingsSummaryCalculator();
        for (TrackedFinding finding : findings) {
            calculator.computeFindingCounts(finding);
        }
        if (reportCategoriesWithoutFindings) {
            calculator.addAdditionalConfiguredQualityIndicators(calculationInfo);
        }
        return calculator.createFindingsSummary(calculationInfo, reportRulesWithoutFindings);
    }

    private void computeFindingCounts(TrackedFinding finding) {
        ETrafficLightColor assessment = finding.getAssessment();
        if (assessment != ETrafficLightColor.RED && assessment != ETrafficLightColor.YELLOW) {
            LOGGER.error("Found invalid assessment '{}', only YELLOW and RED are supported.", (Object)assessment);
        }
        String category = finding.getCategoryName();
        String group = finding.getGroupName();
        String typeId = finding.getTypeId();
        ((CounterSet)this.findingGroupCounts.computeIfAbsent((Object)category, (Object)group, (ignored1, ignored2) -> new CounterSet())).inc((Object)assessment);
        this.allTypeIds.putIfAbsent(typeId, finding.getCodeScopeName());
        ((CounterSet)this.findingTypeIdCounts.computeIfAbsent((Object)group, (Object)typeId, (ignored1, ignored2) -> new CounterSet())).inc((Object)assessment);
        for (Map.Entry guidelineMapping : finding.getGuidelineMapping().entrySet()) {
            for (String ruleIdAndName : (Set)guidelineMapping.getValue()) {
                String guidelineName = (String)guidelineMapping.getKey();
                Optional rule = GuidelineMapping.getInstance().getRule(guidelineName, ruleIdAndName);
                if (rule.isEmpty()) {
                    LOGGER.error("Could not find guideline rule '{}' of guideline '{}'.", (Object)ruleIdAndName, (Object)guidelineName);
                    continue;
                }
                this.rulesCounter.computeIfAbsent((RulesetInfo)rule.get(), ignored -> new CounterSet()).inc((Object)assessment);
            }
            this.findingGuidelineCounts.inc((Object)((String)guidelineMapping.getKey()));
            this.findingGuidelineRuleCounts.computeIfAbsent((String)guidelineMapping.getKey(), ignored -> new CounterSet()).incAll((Collection)guidelineMapping.getValue());
        }
    }

    private void addAdditionalConfiguredQualityIndicators(FindingsCalculationInfo calculationInfo) throws StorageException {
        PublicProjectId projectId = calculationInfo.projectId();
        IndexLayer indexLayer = calculationInfo.indexLayer();
        try {
            AnalysisProfileIndex analysisProfileIndex = (AnalysisProfileIndex)indexLayer.openGlobalIndex(AnalysisProfileIndex.class);
            ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfiguration((IProjectId)projectId, (IndexLayer)indexLayer);
            ConfigurationTemplateManager templateManager = AnalysisProfileUtils.getTemplateManager(analysisProfileIndex, indexLayer.openGlobalStorageSystem(), projectConfiguration);
            CodeScopeAware<List<QualityIndicator>> configuredQualityIndicators = AnalysisProfileUtils.getConfiguredQualityIndicatorsPerCodeScope(indexLayer, projectConfiguration);
            this.populateConfiguredQualityIndicatorToFindingsSummary(configuredQualityIndicators, templateManager);
        }
        catch (ProjectConfigurationException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private void populateConfiguredQualityIndicatorToFindingsSummary(CodeScopeAware<List<QualityIndicator>> qualityIndicators, ConfigurationTemplateManager templateManager) {
        for (CodeScopeName codeScopeName : qualityIndicators.getCodeScopeNames()) {
            for (QualityIndicator qualityIndicator : (List)qualityIndicators.getValue(codeScopeName)) {
                String category = qualityIndicator.getName();
                UnmodifiableList groups = qualityIndicator.getGroups();
                this.addCounterSetToGroup(templateManager, codeScopeName, (UnmodifiableList<AnalysisGroup>)groups, category);
            }
        }
    }

    private void addCounterSetToGroup(ConfigurationTemplateManager templateManager, CodeScopeName codeScopeName, UnmodifiableList<AnalysisGroup> groups, String category) {
        for (AnalysisGroup analysisGroup : groups) {
            String groupName = analysisGroup.getName();
            AnalysisGroupDescriptor group = templateManager.getAnalysisGroup(groupName, codeScopeName);
            if (group == null) {
                LOGGER.error("Analysis group {} found in analysis profile but not available in configuration template", (Object)groupName);
                continue;
            }
            if (!FindingsSummaryCalculator.hasFindingDescriptor(group) || this.findingGroupCounts.containsKey((Object)category, (Object)groupName)) continue;
            this.findingGroupCounts.putValue((Object)category, (Object)groupName, (Object)new CounterSet());
        }
    }

    private static boolean hasFindingDescriptor(AnalysisGroupDescriptor analysisGroupDescriptor) {
        UnmodifiableList configurationItems = analysisGroupDescriptor.getConfigurationItems();
        for (ConfigurationItemBase configurationItemBase : configurationItems) {
            if (!(configurationItemBase instanceof FindingDescriptor)) continue;
            return true;
        }
        return false;
    }

    private FindingsSummaryInfo createFindingsSummary(FindingsCalculationInfo calculationInfo, boolean reportRulesWithoutFindings) throws StorageException {
        FindingsSchemaIndex findingsSchemaIndex = (FindingsSchemaIndex)calculationInfo.projectStorageSystem().openProjectIndex(FindingsSchemaIndex.class, null);
        Map<String, String> typeIdToName = this.getTypeIdToName(findingsSchemaIndex);
        List<FindingsSummaryCategoryInfo> categoryInfos = this.getCategoryInfos(typeIdToName);
        List<FindingsSummaryGuidelineInfo> guidelineInfos = GuidelineSummaryCalculator.createGuidelineSummary(calculationInfo, reportRulesWithoutFindings, this.rulesCounter);
        return new FindingsSummaryInfo(categoryInfos, guidelineInfos);
    }

    private Map<String, String> getTypeIdToName(FindingsSchemaIndex findingsSchemaIndex) throws StorageException {
        CodeScopeAware typeIdByCodeScope = CodeScopeAware.empty();
        this.allTypeIds.forEach((id, scope) -> ((Set)typeIdByCodeScope.getOrComputeValue(scope, ignored -> new HashSet())).add(id));
        CodeScopeAware findingTypeDescriptions = findingsSchemaIndex.getFindingTypeDescriptions(typeIdByCodeScope);
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, CodeScopeName> entry : this.allTypeIds.entrySet()) {
            String typeId = entry.getKey();
            CodeScopeName codeScope = entry.getValue();
            String typeName = Optional.ofNullable((FindingTypeDescription)((Map)findingTypeDescriptions.getValue(codeScope)).get(typeId)).map(FindingTypeDescription::getName).orElse(typeId);
            result.put(typeId, typeName);
        }
        return result;
    }

    private List<FindingsSummaryCategoryInfo> getCategoryInfos(Map<String, String> typeIdToName) {
        ArrayList<FindingsSummaryCategoryInfo> categoryInfos = new ArrayList<FindingsSummaryCategoryInfo>();
        for (String categoryName : CollectionUtils.sort((Collection)this.findingGroupCounts.getFirstKeys())) {
            FindingsSummaryCategoryInfo categoryInfo = new FindingsSummaryCategoryInfo(categoryName);
            for (String group : CollectionUtils.sort((Collection)this.findingGroupCounts.getSecondKeys((Object)categoryName))) {
                CounterSet detailedCounter = (CounterSet)this.findingGroupCounts.getValue((Object)categoryName, (Object)group);
                FindingsSummaryGroupInfo groupInfo = new FindingsSummaryGroupInfo(group, detailedCounter.getTotal(), detailedCounter.getValue((Object)ETrafficLightColor.RED));
                for (String typeId : CollectionUtils.sort((Collection)this.findingTypeIdCounts.getSecondKeys((Object)group))) {
                    CounterSet detailedTypesCounter = (CounterSet)this.findingTypeIdCounts.getValue((Object)group, (Object)typeId);
                    FindingsSummaryTypeIdInfo typeIdInfo = new FindingsSummaryTypeIdInfo(typeIdToName.get(typeId), typeId, detailedTypesCounter.getTotal(), detailedTypesCounter.getValue((Object)ETrafficLightColor.RED));
                    groupInfo.addTypeIdInfo(typeIdInfo);
                }
                categoryInfo.addGroupInfo(groupInfo);
            }
            categoryInfos.add(categoryInfo);
        }
        return categoryInfos;
    }
}

