/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.clangtidy.outsourced_analysis;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.findings.clangtidy.outsourced_analysis.teamscale_server.ClangTidyExecutionServerCredentialsNameOption;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class ClangTidyOutsourcedAnalysisUtils {
    private static final String BASE_CREDENTIALS_ERROR_MESSAGE = "Outsourcing ClangTidy analyses was enabled, but credentials for the analysis service are not fully configured. ";

    public static ExternalCredentials getClangTidyAnalysisServiceCredentials(ServerOptionIndex serverOptions, IExternalCredentialsProvider credentialsProvider) throws StorageException {
        String credentialsName = ClangTidyExecutionServerCredentialsNameOption.getCredentialsName(serverOptions);
        if (credentialsName == null) {
            throw new StorageException("Outsourcing ClangTidy analyses was enabled, but credentials for the analysis service are not fully configured. Please set the 'External-account name for the ClangTidy analysis execution server' option in the administrator settings.");
        }
        ExternalCredentials externalCredentials = credentialsProvider.getExternalCredentials(credentialsName);
        if (externalCredentials == null) {
            throw new StorageException("Outsourcing ClangTidy analyses was enabled, but credentials for the analysis service are not fully configured. Please create an external account with the name '" + credentialsName + "' (configured in the administrator settings).");
        }
        return externalCredentials;
    }

    private ClangTidyOutsourcedAnalysisUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

