/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.findings.sonarlint.independent_analysis;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.core.rest.client.Retrofit;
import com.teamscale.index.findings.sonarlint.SonarLintFinding;
import com.teamscale.index.findings.sonarlint.SonarLintFindingsSynchronizerBase;
import com.teamscale.index.findings.sonarlint.independent_analysis.ESonarLintIndependentAnalysisStatus;
import com.teamscale.index.findings.sonarlint.independent_analysis.ISonarLintIndependentAnalysisServiceApi;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintFindingTransport;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisSessionsIndex;
import com.teamscale.index.findings.sonarlint.independent_analysis.SonarLintIndependentAnalysisUtils;
import com.teamscale.index.resource.BasicTokenElementIndex;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.IndexFinding;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class SonarLintIndependentAnalysisPull
extends SonarLintFindingsSynchronizerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Duration RETRY_INTERVAL = Duration.ofMinutes(10L);
    @DeltaSource(value=SonarLintIndependentAnalysisSessionsIndex.class)
    private KeyDelta changedAnalysisSessions;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ExternalCredentialsIndex credentialsProvider;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ServerOptionIndex serverOptions;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex tokenElementsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private SonarLintIndependentAnalysisSessionsIndex sessionsIndex;
    private ISonarLintIndependentAnalysisServiceApi service;

    public void execute() throws Exception {
        if (this.changedAnalysisSessions.isEmpty()) {
            LOGGER.debug("Received no session. Maybe the push job failed, hence no analysis session was created.");
            return;
        }
        ExternalCredentials credentials = SonarLintIndependentAnalysisUtils.getSonarLintAnalysisServiceCredentials(this.serverOptions, (IExternalCredentialsProvider)this.credentialsProvider);
        this.service = (ISonarLintIndependentAnalysisServiceApi)Retrofit.builder((String)credentials.uri).withBasicNTLMAuthentication(credentials.username, credentials.password).withInteractionLogger(LOGGER).create(ISonarLintIndependentAnalysisServiceApi.class);
        List sessionKeys = this.changedAnalysisSessions.getAddedOrChangedKeysAsStrings();
        Map<String, CodeScopeName> codeScopesBySession = this.sessionsIndex.getCodeScopesBySession(sessionKeys);
        for (String sessionKey : codeScopesBySession.keySet()) {
            this.checkStatusesAndRequestRescheduleIfRequired(sessionKey);
        }
        this.fetchAndPersistAnalysisResults(codeScopesBySession);
    }

    private void fetchAndPersistAnalysisResults(Map<String, CodeScopeName> codeScopesBySession) throws ServiceCallException, StorageException {
        CodeScopeAware findingsByPathPerCodeScope = CodeScopeAware.empty();
        for (Map.Entry<String, CodeScopeName> codeScopeBySession : codeScopesBySession.entrySet()) {
            String sessionKey = codeScopeBySession.getKey();
            CodeScopeName codeScopeName = codeScopeBySession.getValue();
            ListMap findingsByPath = new ListMap();
            ListMap<String, SonarLintFindingTransport> findingsTransports = this.service.getAnalysisResultsByPath(sessionKey);
            for (Map.Entry transportFindings : findingsTransports.entrySet()) {
                findingsByPath.addAll((Object)((String)transportFindings.getKey()), (Collection)CollectionUtils.map((Collection)((Collection)transportFindings.getValue()), SonarLintFindingTransport::asFinding));
            }
            findingsByPathPerCodeScope.setValue(codeScopeName, this.toIndexFindings((ListMap<String, SonarLintFinding>)findingsByPath, this.readElementsByPathFromIndex((Set<String>)findingsByPath.getKeys())));
        }
        this.synchronizeFindings((CodeScopeAware<ListMap<String, IndexFinding>>)findingsByPathPerCodeScope);
    }

    private void checkStatusesAndRequestRescheduleIfRequired(String sessionKey) throws ServiceCallException, RescheduleRequestedException {
        LOGGER.debug("Fetching analysis status for session {}.", (Object)sessionKey);
        if (!this.isAnalysisDone(sessionKey)) {
            throw new RescheduleRequestedException(Instant.now().plus(RETRY_INTERVAL));
        }
        LOGGER.debug("Session {} finished analysis. Fetching results.", (Object)sessionKey);
    }

    private boolean isAnalysisDone(String sessionKey) throws ServiceCallException {
        return switch (this.service.getAnalysisStatus(sessionKey)) {
            default -> throw new MatchException(null, null);
            case ESonarLintIndependentAnalysisStatus.SCHEDULED, ESonarLintIndependentAnalysisStatus.RUNNING -> {
                LOGGER.debug("Session {} is still in progress.", (Object)sessionKey);
                yield false;
            }
            case ESonarLintIndependentAnalysisStatus.DONE -> {
                LOGGER.debug("Session {} successfully finished analysis.", (Object)sessionKey);
                yield true;
            }
            case ESonarLintIndependentAnalysisStatus.ERROR -> {
                LOGGER.debug("Session {} finished with an error.", (Object)sessionKey);
                yield true;
            }
            case ESonarLintIndependentAnalysisStatus.UNKNOWN -> throw new ServiceCallException("Scheduled with session key " + sessionKey + " not known to the service. Findings are probably incomplete.");
        };
    }

    private Map<String, BasicTokenElementInfo> readElementsByPathFromIndex(Set<String> paths) throws StorageException {
        return CollectionUtils.zipToMap(paths.iterator(), CollectionUtils.mapWithException(paths, this.tokenElementsIndex::getTokenElement).iterator());
    }
}

