/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.gitbridge.abap.code_inspector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.gitbridge.abap.code_inspector.CodeInspectorGitUtils;
import org.conqat.engine.abap.codeinspector.CodeInspectorUtils;
import org.conqat.engine.abap.codeinspector.ECodeInspectorMessageType;
import org.conqat.engine.abap.codeinspector.ECodeInspectorTestType;

public class CodeInspectorData {
    private static final String INSPECID_PROPERTY = "INSPECID";
    private static final String INSPECVERS_PROPERTY = "INSPECVERS";
    private static final String CIUSER_PROPERTY = "CIUSER";
    private static final String OBJTYPE_PROPERTY = "OBJTYPE";
    private static final String OBJNAME_PROPERTY = "OBJNAME";
    private static final String TEST_PROPERTY = "TEST";
    private static final String ERRCNT_PROPERTY = "ERRCNT";
    private static final String CONSECCNT_PROPERTY = "CONSECCNT";
    private static final String SOBJNAME_PROPERTY = "SOBJNAME";
    private static final String SOBJTYPE_PROPERTY = "SOBJTYPE";
    private static final String LINE_PROPERTY = "LINE";
    private static final String COL_PROPERTY = "COL";
    private static final String KIND_PROPERTY = "KIND";
    private static final String CODE_PROPERTY = "CODE";
    private static final String PARAM1_PROPERTY = "PARAM1";
    private static final String PARAM2_PROPERTY = "PARAM2";
    private static final String PARAM3_PROPERTY = "PARAM3";
    private static final String TEXT_PROPERTY = "TEXT";
    private static final String PARAM4_PROPERTY = "PARAM4";
    @JsonProperty(value="INSPECID")
    private final String elementId;
    @JsonProperty(value="INSPECVERS")
    private final String elementVersion;
    @JsonProperty(value="CIUSER")
    private final String responsibleUser;
    @JsonProperty(value="OBJTYPE")
    private final String objectType;
    @JsonProperty(value="OBJNAME")
    private final String objectName;
    @JsonProperty(value="TEST")
    private final String objectTypeName;
    @JsonProperty(value="ERRCNT")
    private final int cumulativeErrorCounter;
    @JsonProperty(value="CONSECCNT")
    private final int consecutiveLongMessageCounter;
    @JsonProperty(value="SOBJNAME")
    private final String sObjectName;
    @JsonProperty(value="SOBJTYPE")
    private final String sObjectType;
    @JsonProperty(value="LINE")
    private final int lineNumber;
    @JsonProperty(value="COL")
    private final int columnNumber;
    @JsonProperty(value="KIND")
    private final String messageType;
    @JsonProperty(value="CODE")
    private final String messageId;
    @JsonProperty(value="PARAM1")
    private final String param1;
    @JsonProperty(value="PARAM2")
    private final String param2;
    @JsonProperty(value="PARAM3")
    private final String param3;
    @JsonProperty(value="PARAM4")
    private final String param4;
    @JsonProperty(value="TEXT")
    private final String messageText;
    @JsonProperty(value="testType")
    private final ECodeInspectorTestType testType;
    @JsonProperty(value="findingTypeId")
    private final String findingTypeId;
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="startLine")
    private int startLine;

    @JsonCreator
    public CodeInspectorData(@JsonProperty(value="INSPECID") String inspecid, @JsonProperty(value="INSPECVERS") String inspecvers, @JsonProperty(value="CIUSER") String ciuser, @JsonProperty(value="OBJTYPE") String objtype, @JsonProperty(value="OBJNAME") String objname, @JsonProperty(value="TEST") String test, @JsonProperty(value="ERRCNT") int errcnt, @JsonProperty(value="CONSECCNT") int conseccnt, @JsonProperty(value="SOBJNAME") String sobjname, @JsonProperty(value="SOBJTYPE") String sobjtype, @JsonProperty(value="LINE") int line, @JsonProperty(value="COL") int col, @JsonProperty(value="KIND") String kind, @JsonProperty(value="CODE") String code, @JsonProperty(value="PARAM1") String param1, @JsonProperty(value="PARAM2") String param2, @JsonProperty(value="PARAM3") String param3, @JsonProperty(value="PARAM4") String param4, @JsonProperty(value="TEXT") String text) {
        this.elementId = inspecid;
        this.elementVersion = inspecvers;
        this.responsibleUser = ciuser;
        this.objectType = objtype;
        this.objectName = objname;
        this.objectTypeName = test;
        this.cumulativeErrorCounter = errcnt;
        this.consecutiveLongMessageCounter = conseccnt;
        this.sObjectName = sobjname;
        this.sObjectType = sobjtype;
        this.lineNumber = line;
        this.columnNumber = col;
        this.messageType = kind;
        this.messageId = code;
        this.param1 = param1;
        this.param2 = param2;
        this.param3 = param3;
        this.param4 = param4;
        this.messageText = text;
        this.startLine = this.lineNumber;
        this.testType = ECodeInspectorTestType.valueOfOrUnkown((String)this.objectTypeName);
        this.message = CodeInspectorUtils.buildFindingsMessage((ECodeInspectorTestType)this.testType, (String)code, (String)text, (String)param1, (String)param2, (String)param3, (String)param4);
        this.findingTypeId = CodeInspectorUtils.buildRuleId((ECodeInspectorTestType)this.testType, (String)test, (String)code, (ECodeInspectorMessageType)ECodeInspectorMessageType.valueOf((String)this.messageType));
    }

    public void addElementOffset(int offset) {
        this.startLine = this.lineNumber + offset;
    }

    public String getElementId() {
        return this.elementId;
    }

    public String getElementVersion() {
        return this.elementVersion;
    }

    public String getResponsibleUser() {
        return this.responsibleUser;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getObjectTypeName() {
        return this.objectTypeName;
    }

    public int getCumulativeErrorCounter() {
        return this.cumulativeErrorCounter;
    }

    public int getConsecutiveLongMessageCounter() {
        return this.consecutiveLongMessageCounter;
    }

    public String getsObjectName() {
        return this.sObjectName;
    }

    public String getsObjectType() {
        return this.sObjectType;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getParam1() {
        return this.param1;
    }

    public String getParam2() {
        return this.param2;
    }

    public String getParam3() {
        return this.param3;
    }

    public String getParam4() {
        return this.param4;
    }

    public String getMessageText() {
        return this.messageText;
    }

    public ECodeInspectorTestType getTestType() {
        return this.testType;
    }

    public String getFindingTypeId() {
        return this.findingTypeId;
    }

    public String getMessage() {
        return this.message;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public boolean isFailedExecutionOfExtendedCheck() {
        if (!this.testType.isExtendedCheck()) {
            return false;
        }
        return CodeInspectorGitUtils.FAILED_EXTENDED_CHECK_MESSAGE_CODES.contains(this.getMessageId());
    }
}

