/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.codebeamer.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.issues.BugTrackerException;
import com.teamscale.index.issues.codebeamer.client.ICodebeamerClient;
import com.teamscale.index.issues.codebeamer.client.model.AbstractTrackerItemAssociation;
import com.teamscale.index.issues.codebeamer.client.model.Association;
import com.teamscale.index.issues.codebeamer.client.model.TrackerItemRevision;
import com.teamscale.index.issues.codebeamer.client.model.references.AbstractTrackerItemReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import retrofit2.Call;

public record TrackerItemRelationsResult(@JsonProperty(value="downstreamReferences") List<AbstractTrackerItemReference> downstreamTrackerItemReferences, @JsonProperty(value="incomingAssociations") List<AbstractTrackerItemAssociation> incomingTrackerItemAssociations, @JsonProperty(value="isLastPage") boolean isLastPage, @JsonProperty(value="itemCount") int itemCount, @JsonProperty(value="itemId") TrackerItemRevision itemId, @JsonProperty(value="outgoingAssociations") List<AbstractTrackerItemAssociation> outgoingTrackerItemAssociations, @JsonProperty(value="page") int page, @JsonProperty(value="pageSize") int pageSize, @JsonProperty(value="upstreamReferences") List<AbstractTrackerItemReference> upstreamTrackerItemReferences) {
    public List<Association> resolveAssociations(ICodebeamerClient client) throws BugTrackerException {
        ArrayList<Association> associations = new ArrayList<Association>();
        associations.addAll(TrackerItemRelationsResult.resolveAssociations(client, this.incomingTrackerItemAssociations));
        associations.addAll(TrackerItemRelationsResult.resolveAssociations(client, this.outgoingTrackerItemAssociations));
        associations.addAll(TrackerItemRelationsResult.resolveReferences(client, this.upstreamTrackerItemReferences));
        associations.addAll(TrackerItemRelationsResult.resolveReferences(client, this.downstreamTrackerItemReferences));
        return associations;
    }

    private static List<Association> resolveReferences(ICodebeamerClient client, List<AbstractTrackerItemReference> associations) throws BugTrackerException {
        ArrayList<Association> result = new ArrayList<Association>();
        for (AbstractTrackerItemReference association : associations) {
            result.add(TrackerItemRelationsResult.resolveAssociationOrReference(client, association.getId()));
        }
        return result;
    }

    private static Association resolveAssociationOrReference(ICodebeamerClient client, int id) throws BugTrackerException {
        Call<Association> call = client.getAssociation(id);
        try {
            return (Association)call.execute().body();
        }
        catch (IOException e) {
            throw new BugTrackerException("Could not fetch association with ID %d".formatted(id), e);
        }
    }

    private static List<Association> resolveAssociations(ICodebeamerClient client, List<AbstractTrackerItemAssociation> associations) throws BugTrackerException {
        ArrayList<Association> result = new ArrayList<Association>();
        for (AbstractTrackerItemAssociation association : associations) {
            result.add(TrackerItemRelationsResult.resolveAssociationOrReference(client, association.id));
        }
        return result;
    }
}

