/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.github;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.authenticate.github.GitHubUtils;
import com.teamscale.index.issues.github.GitHubIssueSynchronizerBase;
import com.teamscale.index.issues.github.client.GitHubIssueClient;
import com.teamscale.index.repository.git.common.PlatformRepositoryIdentifier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.Pair;

@AnalysisStep(hints={EAnalysisStepParameter.IGNORE_FOR_ROLLBACK})
public class CredentialsBasedGitHubIssueSynchronizer
extends GitHubIssueSynchronizerBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private String repositoryUser;
    private String repositoryName;

    @Override
    protected void init() {
        String url = this.getUrl();
        Pair repositoryData = (Pair)GitHubUtils.getUserAndRepositoryNameFromUrl((String)url).orElseThrow(() -> new IllegalArgumentException("Illegal repository URL: " + url));
        this.repositoryUser = (String)repositoryData.getFirst();
        this.repositoryName = (String)repositoryData.getSecond();
        String githubUrl = url.substring(0, url.indexOf(this.repositoryUser));
        this.gitHubClient = new GitHubIssueClient(GitHubUtils.getApiBaseUrl((String)githubUrl), this.getUsername(), this.getPassword(), LOGGER);
        this.determineStandardFieldTypeMappings();
    }

    @Override
    protected PlatformRepositoryIdentifier getRepositoryIdentifier() {
        return new PlatformRepositoryIdentifier(this.repositoryUser, this.repositoryName);
    }
}

