/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.issues.jira.voting;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.conqat.lib.commons.string.StringUtils;

final class JiraIssueUpdatePayloadBuilder {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ObjectNode payload = this.objectMapper.createObjectNode();
    private final ObjectNode issueFields = this.objectMapper.createObjectNode();

    JiraIssueUpdatePayloadBuilder() {
    }

    public JsonNode getIssueFields() {
        return this.issueFields;
    }

    public JiraIssueUpdatePayloadBuilder withIssueDescription(String data) {
        this.issueFields.put("description", data);
        return this;
    }

    public JiraIssueUpdatePayloadBuilder withCustomField(String customFieldId, String data) {
        this.issueFields.put(StringUtils.ensureStartsWith((String)customFieldId, (String)"customfield_"), data);
        return this;
    }

    public String build() {
        this.payload.set("fields", (JsonNode)this.issueFields);
        return this.payload.toString();
    }
}

